<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Ad;
use Illuminate\Http\Request;

class AdController extends Controller
{
    public function index()
    {
        $ads = Ad::with('advertiser')->orderBy('created_at', 'desc')->paginate(20);
        return view('admin.ads.index', compact('ads'));
    }

    public function create()
    {
        return view('admin.ads.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'position' => 'required|string',
            'format' => 'required|in:image,html,script',
            'content' => 'required|string',
            'target' => 'required|in:all,home,category,post,municipality',
            'start_at' => 'nullable|date',
            'end_at' => 'nullable|date|after:start_at',
            'impressions_limit' => 'nullable|integer|min:0',
            'clicks_limit' => 'nullable|integer|min:0',
            'status' => 'required|in:active,paused,finished',
        ]);

        if ($request->hasFile('image')) {
            $validated['content'] = $request->file('image')->store('ads', 'public');
        }

        Ad::create($validated);

        return redirect()->route('admin.ads.index')
            ->with('success', 'Anúncio criado com sucesso!');
    }

    public function edit(Ad $ad)
    {
        return view('admin.ads.edit', compact('ad'));
    }

    public function update(Request $request, Ad $ad)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'position' => 'required|string',
            'format' => 'required|in:image,html,script',
            'content' => 'required|string',
            'target' => 'required|in:all,home,category,post,municipality',
            'start_at' => 'nullable|date',
            'end_at' => 'nullable|date|after:start_at',
            'status' => 'required|in:active,paused,finished',
        ]);

        $ad->update($validated);

        return redirect()->route('admin.ads.index')
            ->with('success', 'Anúncio atualizado com sucesso!');
    }

    public function destroy(Ad $ad)
    {
        $ad->delete();
        return redirect()->route('admin.ads.index')
            ->with('success', 'Anúncio excluído com sucesso!');
    }
}

