<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Services\MasterPanelService;
use Illuminate\Support\Facades\Cache;

class LicenseCheck
{
    public function handle(Request $request, Closure $next)
    {
        // Verificar se está em modo de instalação
        if (file_exists(storage_path('app/installed.lock'))) {
            $masterService = app(MasterPanelService::class);
            $validation = $masterService->validateLicense();

            if (!$validation['valid']) {
                if ($request->expectsJson()) {
                    return response()->json([
                        'error' => 'Licença inválida ou expirada',
                        'message' => $validation['message'] ?? 'Entre em contato com o suporte'
                    ], 403);
                }

                return redirect()->route('login')
                    ->with('error', 'Licença inválida ou expirada. Entre em contato com o suporte.');
            }
        }

        return $next($request);
    }
}
