<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PollVote extends Model
{
    use HasFactory;

    protected $fillable = [
        'poll_id',
        'selected_options',
        'voter_ip',
        'voter_session',
    ];

    protected $casts = [
        'selected_options' => 'array',
    ];

    public function poll()
    {
        return $this->belongsTo(Poll::class);
    }
}

