<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Post extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'user_id',
        'category_id',
        'title',
        'slug',
        'subtitle',
        'excerpt',
        'body',
        'cover_image',
        'credit',
        'hat',
        'source',
        'access',
        'municipio_id',
        'blog',
        'column',
        'featured',
        'is_slide',
        'is_manchete',
        'is_urgent',
        'show_in_more_news',
        'seo_meta',
        'meta_title',
        'meta_description',
        'canonical',
        'tags',
        'views',
        'status',
        'published_at',
    ];

    protected $casts = [
        'seo_meta' => 'array',
        'tags' => 'array',
        'featured' => 'boolean',
        'is_slide' => 'boolean',
        'is_manchete' => 'boolean',
        'is_urgent' => 'boolean',
        'show_in_more_news' => 'boolean',
        'published_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function images()
    {
        return $this->hasMany(PostImage::class);
    }

    public function getUrlAttribute()
    {
        return url('/noticia/' . $this->slug);
    }
}

