<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Video extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'user_id',
        'category_id',
        'title',
        'provider',
        'provider_id',
        'url',
        'thumbnail',
        'description',
        'tags',
        'publish_on_site',
        'push_notification',
        'status',
        'published_at',
    ];

    protected $casts = [
        'tags' => 'array',
        'publish_on_site' => 'boolean',
        'push_notification' => 'boolean',
        'published_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }
}

