<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('posts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('category_id')->constrained()->onDelete('restrict');
            $table->string('title');
            $table->string('slug')->unique();
            $table->string('subtitle')->nullable();
            $table->text('excerpt')->nullable();
            $table->longText('body');
            $table->string('cover_image')->nullable();
            $table->string('credit')->nullable();
            $table->string('hat')->nullable(); // Chapéu
            $table->string('source')->nullable(); // Fonte
            $table->enum('access', ['public', 'subscribed'])->default('public');
            $table->unsignedBigInteger('municipio_id')->nullable();
            $table->string('blog')->nullable();
            $table->string('column')->nullable();
            
            // Flags de destaque
            $table->boolean('featured')->default(false);
            $table->boolean('is_slide')->default(false);
            $table->boolean('is_manchete')->default(false);
            $table->boolean('is_urgent')->default(false);
            $table->boolean('show_in_more_news')->default(false);
            
            // SEO
            $table->json('seo_meta')->nullable();
            $table->string('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->string('canonical')->nullable();
            
            // Tags
            $table->json('tags')->nullable();
            
            // Estatísticas
            $table->unsignedInteger('views')->default(0);
            
            // Status e publicação
            $table->enum('status', ['draft', 'pending', 'published', 'archived'])->default('draft');
            $table->timestamp('published_at')->nullable();
            
            $table->timestamps();
            $table->softDeletes();
            
            $table->index('status');
            $table->index('published_at');
            $table->index('featured');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('posts');
    }
};

