<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('readers', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('whatsapp_number', 20); // DDD+Número (ex: 27992494563)
            $table->json('categories_interest')->nullable(); // IDs das categorias
            $table->boolean('receive_group')->default(false); // Receber no grupo
            $table->boolean('receive_private')->default(true); // Receber privado
            $table->string('city')->nullable();
            $table->string('state', 2)->nullable();
            $table->enum('status', ['active', 'inactive', 'blocked'])->default('active');
            $table->timestamp('last_notification_at')->nullable();
            $table->timestamps();
            $table->softDeletes();
            
            $table->index('whatsapp_number');
            $table->index('status');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('readers');
    }
};

