<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('ads', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Nome da campanha
            $table->foreignId('advertiser_id')->nullable()->constrained('users')->onDelete('set null');
            $table->string('position'); // home_top_970x150, sidebar_300x600, etc
            $table->enum('format', ['image', 'html', 'script'])->default('image');
            $table->text('content'); // URL da imagem, HTML ou script
            $table->enum('target', ['all', 'home', 'category', 'post', 'municipality'])->default('all');
            $table->json('target_data')->nullable(); // IDs específicos se target não for 'all'
            $table->dateTime('start_at')->nullable();
            $table->dateTime('end_at')->nullable();
            $table->unsignedInteger('impressions_limit')->nullable();
            $table->unsignedInteger('clicks_limit')->nullable();
            $table->unsignedInteger('impressions_count')->default(0);
            $table->unsignedInteger('clicks_count')->default(0);
            $table->enum('status', ['active', 'paused', 'finished'])->default('active');
            $table->timestamps();
            
            $table->index('position');
            $table->index('status');
            $table->index('start_at');
            $table->index('end_at');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ads');
    }
};

