<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('polls', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('title');
            $table->json('options'); // [{"text": "Opção 1", "image": null}, ...]
            $table->string('image')->nullable();
            $table->text('description')->nullable();
            $table->boolean('allow_multiple_votes')->default(false);
            $table->boolean('show_results_after_vote')->default(true);
            $table->unsignedInteger('total_votes')->default(0);
            $table->dateTime('ends_at')->nullable();
            $table->enum('status', ['draft', 'active', 'finished'])->default('draft');
            $table->timestamp('published_at')->nullable();
            $table->timestamps();
            $table->softDeletes();
            
            $table->index('status');
            $table->index('ends_at');
        });

        Schema::create('poll_votes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('poll_id')->constrained()->onDelete('cascade');
            $table->json('selected_options'); // IDs das opções selecionadas
            $table->string('voter_ip', 45)->nullable();
            $table->string('voter_session')->nullable();
            $table->timestamps();
            
            $table->index('poll_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('poll_votes');
        Schema::dropIfExists('polls');
    }
};

