@extends('layouts.admin')

@section('title', 'Dashboard')

@section('content')
<div class="row">
    <div class="col-md-3 mb-4">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <h5 class="card-title">Notícias Hoje</h5>
                <h2>{{ $stats['posts_today'] }}</h2>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-4">
        <div class="card text-white bg-success">
            <div class="card-body">
                <h5 class="card-title">Total Notícias</h5>
                <h2>{{ $stats['posts_total'] }}</h2>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-4">
        <div class="card text-white bg-info">
            <div class="card-body">
                <h5 class="card-title">Vídeos</h5>
                <h2>{{ $stats['videos_total'] }}</h2>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-4">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <h5 class="card-title">Leitores</h5>
                <h2>{{ $stats['readers_total'] }}</h2>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5>Últimas Notícias</h5>
            </div>
            <div class="card-body">
                <div class="list-group">
                    @foreach($recentPosts as $post)
                    <a href="{{ route('admin.posts.edit', $post) }}" class="list-group-item list-group-item-action">
                        <div class="d-flex w-100 justify-content-between">
                            <h6 class="mb-1">{{ $post->title }}</h6>
                            <small>{{ $post->created_at->format('d/m/Y H:i') }}</small>
                        </div>
                        <p class="mb-1">{{ $post->category->name ?? 'Sem categoria' }}</p>
                        <small>Por {{ $post->user->name }}</small>
                    </a>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5>Acesso Rápido</h5>
            </div>
            <div class="card-body">
                <a href="{{ route('admin.posts.create') }}" class="btn btn-primary w-100 mb-2">
                    <i class="bi bi-plus-circle"></i> Nova Notícia
                </a>
                <a href="{{ route('admin.videos.create') }}" class="btn btn-success w-100 mb-2">
                    <i class="bi bi-play-circle"></i> Novo Vídeo
                </a>
                <a href="{{ route('admin.galleries.create') }}" class="btn btn-info w-100 mb-2">
                    <i class="bi bi-images"></i> Nova Galeria
                </a>
                <a href="{{ route('admin.ads.create') }}" class="btn btn-warning w-100 mb-2">
                    <i class="bi bi-megaphone"></i> Novo Anúncio
                </a>
            </div>
        </div>
    </div>
</div>
@endsection

