@extends('layouts.admin')

@section('title', 'Editar Notícia')

@section('content')
<div class="card">
    <div class="card-header">
        <h5>Editar Notícia</h5>
    </div>
    <div class="card-body">
        <form action="{{ route('admin.posts.update', $post) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            
            <div class="row">
                <div class="col-md-8">
                    <div class="mb-3">
                        <label class="form-label">Título *</label>
                        <input type="text" name="title" class="form-control" value="{{ old('title', $post->title) }}" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Subtítulo</label>
                        <input type="text" name="subtitle" class="form-control" value="{{ old('subtitle', $post->subtitle) }}">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Chapéu</label>
                        <input type="text" name="hat" class="form-control" value="{{ old('hat', $post->hat) }}">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Fonte</label>
                        <input type="text" name="source" class="form-control" value="{{ old('source', $post->source) }}">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Corpo da Notícia *</label>
                        <textarea name="body" class="form-control" rows="15" required>{{ old('body', $post->body) }}</textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Resumo/Excerpt</label>
                        <textarea name="excerpt" class="form-control" rows="3">{{ old('excerpt', $post->excerpt) }}</textarea>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="mb-3">
                        <label class="form-label">Categoria *</label>
                        <select name="category_id" class="form-select" required>
                            <option value="">Selecione...</option>
                            @foreach($categories as $cat)
                                <option value="{{ $cat->id }}" {{ old('category_id', $post->category_id) == $cat->id ? 'selected' : '' }}>
                                    {{ $cat->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    @if($post->cover_image)
                    <div class="mb-3">
                        <img src="{{ asset('storage/' . $post->cover_image) }}" class="img-fluid rounded" alt="Capa">
                    </div>
                    @endif

                    <div class="mb-3">
                        <label class="form-label">Nova Foto de Capa</label>
                        <input type="file" name="cover_image" class="form-control" accept="image/*">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Crédito da Foto</label>
                        <input type="text" name="credit" class="form-control" value="{{ old('credit', $post->credit) }}">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select">
                            <option value="draft" {{ old('status', $post->status) == 'draft' ? 'selected' : '' }}>Rascunho</option>
                            <option value="pending" {{ old('status', $post->status) == 'pending' ? 'selected' : '' }}>Pendente</option>
                            <option value="published" {{ old('status', $post->status) == 'published' ? 'selected' : '' }}>Publicado</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input type="checkbox" name="featured" class="form-check-input" id="featured" {{ old('featured', $post->featured) ? 'checked' : '' }}>
                            <label class="form-check-label" for="featured">Destaque</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" name="is_slide" class="form-check-input" id="is_slide" {{ old('is_slide', $post->is_slide) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_slide">Slide</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" name="is_manchete" class="form-check-input" id="is_manchete" {{ old('is_manchete', $post->is_manchete) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_manchete">Manchete</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" name="is_urgent" class="form-check-input" id="is_urgent" {{ old('is_urgent', $post->is_urgent) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_urgent">Urgente 24h</label>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Tags</label>
                        <input type="text" name="tags" class="form-control" value="{{ old('tags', is_array($post->tags) ? implode(', ', $post->tags) : '') }}">
                    </div>
                </div>
            </div>

            <div class="mt-4">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-save"></i> Atualizar Notícia
                </button>
                <a href="{{ route('admin.posts.index') }}" class="btn btn-secondary">Cancelar</a>
            </div>
        </form>
    </div>
</div>
@endsection

