# 🔧 Correção do Instalador - Validação de Licença

## ✅ Correções Aplicadas

### 1. **Validação e Correção Automática de URL**
- ✅ Detecta URLs incompletas (sem `https://`)
- ✅ Corrige automaticamente URLs truncadas (`.com.b` → `.com.br`)
- ✅ Valida formato completo da URL antes de fazer requisição

### 2. **Validação de License Key**
- ✅ Valida formato: `PVX-XXXXXXXX-XXXXXXXX-XXXXXXXX`
- ✅ Mensagens de erro mais claras

### 3. **Tratamento de Erros Melhorado**
- ✅ Logs detalhados de cada tentativa
- ✅ Mensagens específicas por tipo de erro (404, 403, 500, conexão)
- ✅ Retry automático (3 tentativas com delay de 500ms)

### 4. **Instalador Completo Criado**
- ✅ Controller: `InstallerController.php`
- ✅ View: `installer/index.blade.php`
- ✅ Rotas: `routes/installer.php`

## 📝 Como Usar

### 1. Acessar o Instalador
```
http://seu-dominio.com/install
```

### 2. Preencher os Campos

**URL do Master Panel:**
```
https://master.canal33.com.br
```

**License Key:**
```
PVX-2A5DAAA7-4E529016-AEDC8613
```

### 3. O Sistema Vai:
- ✅ Corrigir automaticamente a URL se estiver incompleta
- ✅ Validar o formato da License Key
- ✅ Fazer requisição ao Master Panel
- ✅ Mostrar mensagens de erro claras se houver problema

## 🔍 Debug

Se ainda houver erro, verifique:

1. **Logs do Laravel:**
   ```
   storage/logs/laravel.log
   ```
   Procure por: "Validating license during installation"

2. **Testar URL Manualmente:**
   ```bash
   curl https://master.canal33.com.br/api/v1/validate-license?license_key=SUA_CHAVE
   ```

3. **Verificar se o Master Panel está Online:**
   ```
   https://master.canal33.com.br
   ```

## ⚠️ Problemas Comuns

### Erro: "URL do Master Panel inválida"
- Verifique se a URL está completa: `https://master.canal33.com.br`
- Não esqueça o `https://` no início
- Não esqueça o `.br` no final

### Erro: "Erro de conexão"
- Verifique sua conexão com a internet
- Verifique se o Master Panel está online
- Verifique firewall/proxy

### Erro: "Licença inválida"
- Verifique se a License Key está correta
- Verifique se a licença não expirou
- Verifique se a licença está ativa no Master Panel

## 🚀 Próximos Passos

Após validar a licença com sucesso, o instalador irá:
1. Salvar as configurações no `.env`
2. Redirecionar para criar usuário admin
3. Finalizar instalação

