# 📤 Guia Completo - Upload do Portal para o Servidor

## 📋 Informações Importantes

Este guia explica como fazer o upload do portal para o servidor `servidor.canal33.qbr` na pasta `download`.

## 🗂️ Estrutura de Pastas no Servidor

```
servidor.canal33.qbr/
└── download/
    └── portal/  (aqui ficam todos os arquivos do portal)
```

## 📦 O que Fazer Upload

### ✅ Arquivos que DEVEM ser enviados:

1. **Toda a pasta `portal/`** (raiz do projeto Laravel)
   - `app/`
   - `bootstrap/`
   - `config/`
   - `database/`
   - `public/`
   - `resources/`
   - `routes/`
   - `storage/`
   - `vendor/` (ou instalar via composer no servidor)
   - Arquivos raiz: `.env`, `composer.json`, `artisan`, etc.

### ❌ Arquivos que NÃO devem ser enviados:

- `.git/`
- `node_modules/` (se houver)
- `.env.example` (usar `.env` configurado)
- Arquivos temporários
- Logs antigos

## 🔧 Passo a Passo

### 1. Preparar o Arquivo ZIP

```bash
# No seu computador local, dentro da pasta do portal:
# Criar um ZIP com todos os arquivos (exceto .git)
zip -r portal.zip . -x "*.git*" -x "node_modules/*"
```

### 2. Fazer Upload via FTP/SFTP

1. Conecte-se ao servidor `servidor.canal33.qbr`
2. Navegue até a pasta `download/`
3. Faça upload do arquivo `portal.zip`
4. Extraia o arquivo ZIP no servidor

### 3. Configurar Permissões

Após extrair, configure as permissões:

```bash
# No servidor, dentro da pasta portal/
chmod -R 755 storage bootstrap/cache
chmod -R 775 storage/logs
chown -R www-data:www-data storage bootstrap/cache
```

### 4. Configurar o .env

Edite o arquivo `.env` no servidor com as configurações corretas:

```env
APP_NAME="Portal de Notícias"
APP_ENV=production
APP_KEY=base64:SUA_CHAVE_AQUI
APP_DEBUG=false
APP_URL=http://servidor.canal33.qbr/download/portal

DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=nome_do_banco
DB_USERNAME=usuario_banco
DB_PASSWORD=senha_banco
```

### 5. Instalar Dependências

```bash
# No servidor, dentro da pasta portal/
composer install --no-dev --optimize-autoloader
```

### 6. Configurar o Servidor Web

#### Apache (.htaccess)

O arquivo `public/.htaccess` já deve estar configurado. Se não estiver, crie:

```apache
<IfModule mod_rewrite.c>
    <IfModule mod_negotiation.c>
        Options -MultiViews -Indexes
    </IfModule>

    RewriteEngine On

    # Handle Authorization Header
    RewriteCond %{HTTP:Authorization} .
    RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization}]

    # Redirect Trailing Slashes If Not A Folder...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_URI} (.+)/$
    RewriteRule ^ %1 [L,R=301]

    # Send Requests To Front Controller...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteRule ^ index.php [L]
</IfModule>
```

#### Nginx

Se usar Nginx, configure:

```nginx
server {
    listen 80;
    server_name servidor.canal33.qbr;
    root /caminho/para/download/portal/public;

    add_header X-Frame-Options "SAMEORIGIN";
    add_header X-Content-Type-Options "nosniff";

    index index.php;

    charset utf-8;

    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }

    location = /favicon.ico { access_log off; log_not_found off; }
    location = /robots.txt  { access_log off; log_not_found off; }

    error_page 404 /index.php;

    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php8.1-fpm.sock;
        fastcgi_param SCRIPT_FILENAME $realpath_root$fastcgi_script_name;
        include fastcgi_params;
    }

    location ~ /\.(?!well-known).* {
        deny all;
    }
}
```

### 7. Configurar o Document Root

**IMPORTANTE**: O Document Root do servidor web deve apontar para a pasta `public/` do portal, não para a raiz!

```
❌ ERRADO: servidor.canal33.qbr/download/portal/
✅ CORRETO: servidor.canal33.qbr/download/portal/public/
```

### 8. Executar Migrations

```bash
# No servidor, dentro da pasta portal/
php artisan migrate --force
```

### 9. Limpar Cache

```bash
# No servidor, dentro da pasta portal/
php artisan config:cache
php artisan route:cache
php artisan view:cache
php artisan optimize
```

## 🔍 Verificação Pós-Instalação

### Testar Acesso

1. Acesse: `http://servidor.canal33.qbr/download/portal/public/`
2. Verifique se a página inicial carrega
3. Teste as rotas:
   - `/` - Home
   - `/v1` - Template V1
   - `/v2` - Template V2
   - `/admin` - Painel administrativo

### Verificar Logs

```bash
# Ver erros do Laravel
tail -f storage/logs/laravel.log

# Ver erros do PHP
tail -f /var/log/php_errors.log
```

## ⚠️ Problemas Comuns

### 1. Erro 500 - Internal Server Error

**Causa**: Permissões incorretas ou erro no código

**Solução**:
```bash
chmod -R 755 storage bootstrap/cache
chown -R www-data:www-data storage bootstrap/cache
```

### 2. Página em Branco

**Causa**: Erro de PHP ou cache

**Solução**:
```bash
php artisan config:clear
php artisan cache:clear
php artisan view:clear
```

### 3. Erro de Banco de Dados

**Causa**: Configuração incorreta no `.env`

**Solução**: Verifique as credenciais do banco de dados no `.env`

### 4. Assets (CSS/JS) não carregam

**Causa**: Caminho incorreto ou permissões

**Solução**: 
- Verifique se o Document Root aponta para `public/`
- Verifique permissões da pasta `public/`

## 📝 Checklist Final

- [ ] Arquivos enviados para `download/portal/`
- [ ] Permissões configuradas (`storage/` e `bootstrap/cache/`)
- [ ] Arquivo `.env` configurado
- [ ] Dependências instaladas (`composer install`)
- [ ] Document Root aponta para `public/`
- [ ] Migrations executadas
- [ ] Cache limpo e otimizado
- [ ] Site acessível via navegador
- [ ] Logs verificados (sem erros)

## 🆘 Suporte

Se encontrar problemas:

1. Verifique os logs: `storage/logs/laravel.log`
2. Verifique permissões de arquivos
3. Verifique configuração do `.env`
4. Verifique se o PHP está na versão correta (8.1+)
5. Verifique se todas as extensões PHP necessárias estão instaladas

## 📌 Notas Importantes

- **NUNCA** faça commit do arquivo `.env` com senhas reais
- Sempre use `APP_DEBUG=false` em produção
- Mantenha backups regulares do banco de dados
- Configure um cron job para tarefas agendadas (se necessário)

---

**Última atualização**: {{ date('d/m/Y') }}

