# 🔑 Configuração de Licença - Portal de Notícias

## ⚠️ Erro: "Erro ao validar licença"

Se você está vendo este erro, siga os passos abaixo para configurar a licença corretamente.

## 📝 Passo a Passo

### 1. Obter Chave de Licença

A chave de licença é fornecida pelo **Painel Master** após o cadastro do cliente.

### 2. Configurar no Arquivo .env

Edite o arquivo `.env` na raiz do projeto e adicione as seguintes variáveis:

```env
# URL do Master Panel
MASTER_PANEL_URL=https://master.canal33.com.br

# Chave de Licença (fornecida pelo Master Panel)
MASTER_PANEL_LICENSE_KEY=PVX-XXXXXXXX-XXXXXXXX

# API Key (opcional, para recursos avançados)
MASTER_PANEL_API_KEY=sua_api_key_aqui

# API Secret (opcional, para recursos avançados)
MASTER_PANEL_API_SECRET=seu_api_secret_aqui

# Timeout da API (opcional, padrão: 10 segundos)
MASTER_PANEL_API_TIMEOUT=10

# Cache de validação (opcional, padrão: true)
MASTER_PANEL_CACHE_VALIDATION=true

# TTL do cache em minutos (opcional, padrão: 60)
MASTER_PANEL_CACHE_TTL=60

# Desabilitar verificação (APENAS PARA DESENVOLVIMENTO!)
# NUNCA deixe true em produção!
MASTER_PANEL_DISABLE_CHECK=false
```

### 3. Limpar Cache

Após configurar, limpe o cache do Laravel:

```bash
php artisan config:clear
php artisan cache:clear
```

### 4. Verificar Conexão

Teste se a URL do Master Panel está acessível:

```bash
curl https://master.canal33.com.br/api/v1/validate-license?license_key=SUA_CHAVE
```

## 🔧 Modo Desenvolvimento

Se você está em ambiente de desenvolvimento e não tem acesso ao Master Panel, pode desabilitar temporariamente a verificação:

```env
MASTER_PANEL_DISABLE_CHECK=true
```

⚠️ **ATENÇÃO:** NUNCA deixe isso ativado em produção!

## 🐛 Solução de Problemas

### Erro: "URL do Master Panel não configurada"
- Verifique se `MASTER_PANEL_URL` está no `.env`
- Execute `php artisan config:clear`

### Erro: "Chave de licença não configurada"
- Verifique se `MASTER_PANEL_LICENSE_KEY` está no `.env`
- Execute `php artisan config:clear`

### Erro: "Erro de conexão com Master Panel"
- Verifique sua conexão com a internet
- Verifique se a URL do Master Panel está correta
- Verifique se o servidor Master Panel está online
- Verifique firewall/proxy que possa estar bloqueando

### Erro: "Licença inválida ou expirada"
- Verifique se a chave de licença está correta
- Verifique se a licença não expirou
- Entre em contato com o suporte do Master Panel

## 📞 Suporte

Se o problema persistir, entre em contato com o suporte do Master Panel.

