# 🔧 Correção: Erro Monolog/PSR Log

## ❌ Problema
**Erro:** `Declaration of Monolog\Logger::emergency(Stringable|string $message, array $context = []): void must be compatible with PsrExt\Log\LoggerInterface::emergency($message, array $context = [])`

**Causa:** Conflito de versões entre `monolog/monolog` e `psr/log` no PHP 8.2.

## ✅ Solução Rápida

### Opção 1: Usar Script Automático (Recomendado)
1. Acesse: `https://canal33.com.br/fix-monolog.php`
2. O script vai:
   - Remover a pasta `vendor/`
   - Atualizar `composer.json` com versões compatíveis
   - Reinstalar todas as dependências
3. **IMPORTANTE:** Delete o arquivo `fix-monolog.php` após usar!

### Opção 2: Via SSH (Se tiver acesso)
```bash
cd /home/canal33portal/public_html
rm -rf vendor/
composer install --no-dev --optimize-autoloader
```

### Opção 3: Atualizar apenas os pacotes problemáticos
```bash
cd /home/canal33portal/public_html
composer update psr/log monolog/monolog --with-all-dependencies
```

## 📋 O que foi corrigido

1. ✅ `composer.json` atualizado para forçar versões compatíveis:
   - `psr/log: ^3.0`
   - `monolog/monolog: ^3.0`

2. ✅ Script `fix-monolog.php` criado para correção automática

## 🚀 Após a correção

O site deve funcionar normalmente:
- ✅ Front-end: `https://canal33.com.br/`
- ✅ Painel Admin: `https://canal33.com.br/admin/login`

## ⚠️ Importante

1. Execute o script `fix-monolog.php` primeiro
2. Delete o arquivo após usar (segurança)
3. Se ainda houver erro, execute via SSH

## 📝 Nota

Este erro é comum quando há incompatibilidade entre versões do Monolog e PSR Log no PHP 8.2. A solução é garantir que ambas as bibliotecas estejam na versão 3.x, que são compatíveis entre si.

