# Portal Bahia - Painel Administrativo

Sistema de gerenciamento de conteúdo (CMS) para portais de notícias multi-tenant.

**Desenvolvido por:** Robson Rost / Grupo Website VIX

## 📋 Requisitos

- PHP 8.1 ou superior
- Composer
- MySQL 5.7 ou superior
- Extensões PHP: pdo, pdo_mysql, mbstring, openssl, curl, fileinfo, json, xml
- Node.js 16+ e NPM (para assets)
- License Key válida do Master Panel

## 🚀 Instalação

### 1. Instalação Automática

Acesse o instalador em: `http://seu-dominio.com/install`

O instalador irá guiá-lo pelos passos:
1. Verificação de Requisitos
2. Configuração do Banco de Dados
3. Validação de Licença (conexão com Master Panel)
4. Configuração do Administrador
5. Instalação Completa

### 2. Instalação Manual

```bash
# 1. Instalar dependências
composer install
npm install

# 2. Copiar arquivo de ambiente
cp .env.example .env

# 3. Gerar chave da aplicação
php artisan key:generate

# 4. Configurar banco de dados no .env
DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=canal33portal_portalnoticia
DB_USERNAME=canal33portal_portalnoticia
DB_PASSWORD=VtlOq2WsS9vjuE1A

# 5. Configurar Master Panel
MASTER_PANEL_URL=https://master.canal33.com.br
LICENSE_KEY=PVX-XXXXXXXX-XXXXXXXX

# 6. Executar migrations
php artisan migrate

# 7. Importar schema
mysql -u canal33portal_portalnoticia -p canal33portal_portalnoticia < database/schema.sql

# 8. Criar usuário administrador
php artisan tinker
User::create([
    'name' => 'Administrador',
    'email' => 'admin@example.com',
    'password' => bcrypt('senha123'),
    'role' => 'admin',
    'status' => 'active'
]);

# 9. Compilar assets
npm run build
```

## 📁 Estrutura do Projeto

```
portal/
├── app/
│   ├── Http/
│   │   ├── Controllers/
│   │   │   ├── Admin/
│   │   │   │   ├── DashboardController.php
│   │   │   │   ├── NewsController.php
│   │   │   │   ├── VideoController.php
│   │   │   │   ├── GalleryController.php
│   │   │   │   ├── PollController.php
│   │   │   │   ├── AdController.php
│   │   │   │   ├── ClassifiedController.php
│   │   │   │   ├── PluginController.php
│   │   │   │   └── ...
│   │   │   └── Api/
│   │   │       └── MasterPanelController.php
│   │   └── Middleware/
│   │       ├── LicenseCheck.php
│   │       └── MasterPanelAuth.php
│   ├── Models/
│   │   ├── News.php
│   │   ├── Video.php
│   │   ├── Gallery.php
│   │   ├── Category.php
│   │   └── ...
│   └── Services/
│       ├── MasterPanelService.php
│       ├── WhatsAppService.php
│       └── ...
├── database/
│   ├── migrations/
│   └── schema.sql
├── install/
│   └── index.php (Instalador)
├── resources/
│   ├── views/
│   │   └── admin/
│   └── js/
│       └── app.js
├── routes/
│   ├── web.php
│   └── admin.php
└── storage/
    └── app/public/uploads/
```

## 🔧 Configuração

### Integração com Master Panel

O portal se comunica com o Master Panel via API REST para:
- Validar licença
- Verificar atualizações
- Ativar plugins premium
- Buscar informações do cliente

### License Key

A License Key é validada durante a instalação e periodicamente durante o uso.
O portal registra automaticamente o IP e domínio durante a instalação.

### Plugins

Plugins podem ser instalados via:
1. Catálogo do Master Panel (via API)
2. Upload manual (arquivo ZIP)
3. Instalação via Git

Plugins Premium requerem License Key válida.

## 📝 Funcionalidades

### Gerenciamento de Conteúdo

- **Notícias**: Cadastro completo com todos os campos especificados
- **Vídeos**: YouTube, Vimeo, Drive, Upload
- **Galerias**: Upload múltiplo de imagens
- **Enquetes**: Sistema completo de votação
- **Anúncios**: Campanhas e posições
- **Classificados**: Sistema de classificados

### Módulos

- **Usuários e Permissões**: Controle de acesso
- **Categorias**: Organização de conteúdo
- **Municípios**: Diretório de municípios
- **Páginas CMS**: Páginas estáticas
- **Layout**: Personalização de temas
- **Plugins**: Sistema modular

## 🔐 Segurança

- Validação de licença via Master Panel
- Autenticação segura (Laravel Sanctum)
- Proteção CSRF
- Sanitização de inputs
- Logs de auditoria

## 📞 Suporte

Para suporte, entre em contato:
- **Desenvolvedor:** Robson Rost / Grupo Website VIX

---

**Versão:** 1.0.0  
**Última atualização:** 2024

