# Frontend - Portal de Notícias

## Templates Implementados

### V1 - Template Moderno
- **Localização**: `resources/views/frontend/v1/`
- **CSS**: `public/css/v1/main.css`
- **JS**: `public/js/v1/main.js`

**Características:**
- Layout modular com blocos/seções
- Hero banner com 2 chamadas laterais
- Blocos de destaques
- Trending / Em alta
- Blocos por categoria
- Seção de vídeos
- Colunistas
- Sidebar completa com widgets

### V2 - Template Blog Simples
- **Localização**: `resources/views/frontend/v2/`
- **CSS**: `public/css/v2/main.css`
- **JS**: `public/js/v2/main.js`

**Características:**
- Feed linear de notícias
- Layout simples e direto
- Sidebar focada em anúncios
- Widgets básicos

## Rotas

### V1 (Template Moderno)
- `/` - Home
- `/noticia/{slug}` - Página de notícia
- `/categoria/{slug}` - Lista por categoria
- `/buscar?q=termo` - Busca

### V2 (Template Blog)
- `/v2` - Home
- `/v2/noticia/{slug}` - Página de notícia
- `/v2/categoria/{slug}` - Lista por categoria
- `/buscar?q=termo&template=v2` - Busca

## Componentes

### Widgets Disponíveis
- Clima (widget-weather)
- Mais Lidas (widget-popular)
- Vídeos (widget-videos)
- Posts Recentes (widget-recent)

### Partials
- `partials/widgets.blade.php` - Widgets para sidebar
- `partials/search-form.blade.php` - Formulário de busca
- `partials/pagination.blade.php` - Paginação
- `partials/breadcrumb.blade.php` - Breadcrumb

## Funcionalidades

### Implementadas
✅ Layouts responsivos
✅ Sistema de anúncios dinâmicos
✅ Busca com autocomplete (API)
✅ Compartilhamento social
✅ Tags
✅ Galeria de fotos
✅ Sistema de visualizações
✅ Breadcrumb
✅ Paginação
✅ Widgets de sidebar
✅ Lazy loading de imagens
✅ Menu mobile

### Pendentes (Opcionais)
- Modo escuro (V1)
- Comentários
- Newsletter
- Sitemap XML
- Robots.txt

## Configurações

As cores e configurações podem ser alteradas através do helper `setting()`:
- `setting('top_bar_color', '#1e3a8a')` - Cor da barra superior
- `setting('footer_color', '#1e3a8a')` - Cor do rodapé
- `setting('contact_email', 'contato@portal.com')` - Email de contato
- `setting('contact_phone', '(00) 0000-0000')` - Telefone
- `setting('contact_whatsapp', '(00) 00000-0000')` - WhatsApp

## Anúncios

O sistema de anúncios está integrado e suporta:
- **Formatos**: Imagem, HTML, Script
- **Posições**: 300x600 (vertical), 300x250 (retângulo)
- **Targeting**: Todo site, Home, Páginas específicas, Município, Blog, Coluna
- **Rotação**: Automática entre campanhas ativas

## Próximos Passos

Quando receber as fotos dos modelos V1 e V2, ajustaremos:
1. Cores e estilos específicos
2. Espaçamentos e tamanhos
3. Tipografia
4. Ícones e elementos visuais
5. Animações e transições

