# 🧪 Como Testar a Validação de Licença

## 1. Testar URL do Master Panel

Teste se a URL está acessível:

```bash
curl https://master.canal33.com.br/api/v1/validate-license?license_key=TESTE
```

Se retornar JSON, a URL está funcionando.

## 2. Verificar Configuração

No arquivo `.env`, verifique:

```env
MASTER_PANEL_URL=https://master.canal33.com.br
MASTER_PANEL_LICENSE_KEY=sua_chave_real_aqui
```

## 3. Limpar Cache

```bash
php artisan config:clear
php artisan cache:clear
```

## 4. Verificar Logs

Os logs estão em `storage/logs/laravel.log`. Procure por:
- "Validating license"
- "License validation response"
- "Master Panel connection error"

## 5. Modo Desenvolvimento

Se você está instalando e não tem licença ainda:

```env
MASTER_PANEL_DISABLE_CHECK=true
```

⚠️ **NUNCA deixe isso em produção!**

## 6. Verificar se o Master Panel está Online

Acesse no navegador:
```
https://master.canal33.com.br
```

Se a página carregar, o servidor está online.

## 7. Testar Endpoint da API

```bash
curl -v https://master.canal33.com.br/api/v1/validate-license?license_key=SUA_CHAVE
```

O `-v` mostra detalhes da conexão.

## 🔍 Debug

Se ainda houver erro, verifique:
1. Logs do Laravel: `storage/logs/laravel.log`
2. Logs do servidor web (Apache/Nginx)
3. Firewall/proxy que possa estar bloqueando
4. Certificado SSL válido

