<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\News;
use App\Models\Video;
use App\Models\Gallery;
use App\Models\AdCampaign;
use App\Models\Classified;
use Illuminate\Http\Request;

class TrashController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        $type = $request->get('type', 'all');

        $news = collect();
        $videos = collect();
        $galleries = collect();
        $classifieds = collect();

        if ($type === 'all' || $type === 'news') {
            $news = News::onlyTrashed()->with(['user', 'category'])
                ->orderBy('deleted_at', 'desc')
                ->paginate(20, ['*'], 'news_page');
        }

        if ($type === 'all' || $type === 'videos') {
            $videos = Video::onlyTrashed()->with(['user'])
                ->orderBy('deleted_at', 'desc')
                ->paginate(20, ['*'], 'videos_page');
        }

        if ($type === 'all' || $type === 'galleries') {
            $galleries = Gallery::onlyTrashed()->with(['user'])
                ->orderBy('deleted_at', 'desc')
                ->paginate(20, ['*'], 'galleries_page');
        }

        if ($type === 'all' || $type === 'classifieds') {
            $classifieds = Classified::onlyTrashed()->with(['user'])
                ->orderBy('deleted_at', 'desc')
                ->paginate(20, ['*'], 'classifieds_page');
        }

        return view('admin.trash.index', compact('news', 'videos', 'galleries', 'classifieds', 'type'));
    }

    public function restore($type, $id)
    {
        $model = $this->getModel($type);

        if (!$model) {
            return back()->with('error', 'Tipo inválido');
        }

        $item = $model::onlyTrashed()->findOrFail($id);
        $item->restore();

        return back()->with('success', 'Item restaurado com sucesso!');
    }

    public function destroy($type, $id)
    {
        $model = $this->getModel($type);

        if (!$model) {
            return back()->with('error', 'Tipo inválido');
        }

        $item = $model::onlyTrashed()->findOrFail($id);
        
        // Deletar permanentemente
        $item->forceDelete();

        return back()->with('success', 'Item excluído permanentemente!');
    }

    public function empty(Request $request)
    {
        $type = $request->get('type');

        if ($type === 'news') {
            News::onlyTrashed()->forceDelete();
        } elseif ($type === 'videos') {
            Video::onlyTrashed()->forceDelete();
        } elseif ($type === 'galleries') {
            Gallery::onlyTrashed()->forceDelete();
        } elseif ($type === 'classifieds') {
            Classified::onlyTrashed()->forceDelete();
        } else {
            // Limpar tudo
            News::onlyTrashed()->forceDelete();
            Video::onlyTrashed()->forceDelete();
            Gallery::onlyTrashed()->forceDelete();
            Classified::onlyTrashed()->forceDelete();
        }

        return back()->with('success', 'Lixeira esvaziada com sucesso!');
    }

    protected function getModel($type)
    {
        $models = [
            'news' => News::class,
            'videos' => Video::class,
            'galleries' => Gallery::class,
            'classifieds' => Classified::class,
        ];

        return $models[$type] ?? null;
    }
}

