<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\News;

class CategoryController extends Controller
{
    public function show($slug, $template = 'v1')
    {
        $category = Category::where('slug', $slug)->active()->firstOrFail();
        
        $news = News::published()
            ->where('category_id', $category->id)
            ->orderBy('published_at', 'desc')
            ->paginate(12);

        $view = $template === 'v2' ? 'frontend.v2.category' : 'frontend.v1.category';
        
        return view($view, compact('category', 'news'));
    }
}

