<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AdCampaign extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'position_id',
        'name',
        'format',
        'content',
        'image',
        'link',
        'target',
        'target_pages',
        'start_date',
        'end_date',
        'impressions_limit',
        'clicks_limit',
        'impressions',
        'clicks',
        'status',
    ];

    protected $casts = [
        'target_pages' => 'array',
        'start_date' => 'date',
        'end_date' => 'date',
        'impressions_limit' => 'integer',
        'clicks_limit' => 'integer',
        'impressions' => 'integer',
        'clicks' => 'integer',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function position()
    {
        return $this->belongsTo(AdPosition::class);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 'active')
            ->where(function($q) {
                $q->whereNull('start_date')
                  ->orWhere('start_date', '<=', now());
            })
            ->where(function($q) {
                $q->whereNull('end_date')
                  ->orWhere('end_date', '>=', now());
            });
    }

    public function incrementImpressions()
    {
        $this->increment('impressions');
        
        // Verificar limite
        if ($this->impressions_limit && $this->impressions >= $this->impressions_limit) {
            $this->update(['status' => 'finished']);
        }
    }

    public function incrementClicks()
    {
        $this->increment('clicks');
        
        // Verificar limite
        if ($this->clicks_limit && $this->clicks >= $this->clicks_limit) {
            $this->update(['status' => 'finished']);
        }
    }
}

