<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AutoPostJob extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'provider_name',
        'provider_type',
        'provider_url',
        'provider_config',
        'frequency',
        'max_import',
        'default_category_id',
        'create_category_if_not_exists',
        'auto_publish',
        'send_notifications',
        'publish_social',
        'status',
        'last_run_at',
        'last_imported',
        'last_skipped',
    ];

    protected $casts = [
        'provider_config' => 'array',
        'create_category_if_not_exists' => 'boolean',
        'send_notifications' => 'boolean',
        'publish_social' => 'boolean',
        'frequency' => 'integer',
        'max_import' => 'integer',
        'last_imported' => 'integer',
        'last_skipped' => 'integer',
        'last_run_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'default_category_id');
    }

    public function logs()
    {
        return $this->hasMany(AutoPostLog::class, 'job_id');
    }

    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }
}

