<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Municipality extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'slug',
        'uf',
        'ibge_code',
        'status',
    ];

    public function news()
    {
        return $this->hasMany(News::class);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }
}

