<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PollOption extends Model
{
    use HasFactory;

    protected $fillable = [
        'poll_id',
        'option',
        'image',
        'votes',
        'order',
    ];

    protected $casts = [
        'votes' => 'integer',
        'order' => 'integer',
    ];

    public function poll()
    {
        return $this->belongsTo(Poll::class);
    }

    public function getPercentageAttribute()
    {
        if ($this->poll->total_votes == 0) {
            return 0;
        }
        return round(($this->votes / $this->poll->total_votes) * 100, 2);
    }
}

