<?php

namespace App\Services\AutoPost\Adapters;

class DinoAdapter extends BaseAdapter
{
    public function getName(): string
    {
        return 'dino';
    }

    public function fetch(string $url, array $config = []): array
    {
        $apiKey = $config['api_key'] ?? null;
        
        if (!$apiKey) {
            throw new \Exception("API Key do Dino é obrigatória");
        }

        $response = $this->httpGet($url, [
            'Authorization' => 'Bearer ' . $apiKey,
            'Accept' => 'application/json',
        ]);

        if (!$response) {
            return [];
        }

        $data = json_decode($response, true);
        
        if (!isset($data['data']) || !is_array($data['data'])) {
            return [];
        }

        $items = [];
        foreach ($data['data'] as $item) {
            $items[] = $this->normalizeItem([
                'title' => $item['title'] ?? '',
                'subtitle' => $item['subtitle'] ?? null,
                'body' => $item['content'] ?? $item['body'] ?? '',
                'excerpt' => $item['excerpt'] ?? null,
                'url' => $item['url'] ?? $item['link'] ?? null,
                'published_at' => $item['published_at'] ?? $item['date'] ?? now(),
                'category' => $item['category'] ?? $item['category_name'] ?? null,
                'images' => $item['images'] ?? [],
                'author' => $item['author'] ?? null,
            ]);
        }

        return $items;
    }
}

