<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Master Panel URL
    |--------------------------------------------------------------------------
    |
    | URL base do Painel Master para validação de licenças e comunicação
    | com a API.
    |
    */
    'url' => env('MASTER_PANEL_URL', 'https://master.canal33.com.br'),

    /*
    |--------------------------------------------------------------------------
    | License Key
    |--------------------------------------------------------------------------
    |
    | Chave de licença do portal. Esta chave é fornecida pelo Painel Master
    | após o cadastro do cliente.
    |
    */
    'license_key' => env('MASTER_PANEL_LICENSE_KEY', null),

    /*
    |--------------------------------------------------------------------------
    | API Key
    |--------------------------------------------------------------------------
    |
    | Chave de API para autenticação nas requisições ao Master Panel.
    | Gerada automaticamente no cadastro do cliente.
    |
    */
    'api_key' => env('MASTER_PANEL_API_KEY', null),

    /*
    |--------------------------------------------------------------------------
    | API Secret
    |--------------------------------------------------------------------------
    |
    | Secret da API para autenticação nas requisições ao Master Panel.
    | Gerada automaticamente no cadastro do cliente.
    |
    */
    'api_secret' => env('MASTER_PANEL_API_SECRET', null),

    /*
    |--------------------------------------------------------------------------
    | API Timeout
    |--------------------------------------------------------------------------
    |
    | Timeout em segundos para requisições à API do Master Panel.
    |
    */
    'api_timeout' => env('MASTER_PANEL_API_TIMEOUT', 10),

    /*
    |--------------------------------------------------------------------------
    | Cache License Validation
    |--------------------------------------------------------------------------
    |
    | Se true, cacheia o resultado da validação de licença para evitar
    | requisições excessivas ao Master Panel.
    |
    */
    'cache_license_validation' => env('MASTER_PANEL_CACHE_VALIDATION', true),

    /*
    |--------------------------------------------------------------------------
    | Cache TTL
    |--------------------------------------------------------------------------
    |
    | Tempo de vida do cache de validação em minutos.
    |
    */
    'cache_ttl' => env('MASTER_PANEL_CACHE_TTL', 60),

    /*
    |--------------------------------------------------------------------------
    | Disable License Check
    |--------------------------------------------------------------------------
    |
    | Se true, desabilita a verificação de licença (útil para desenvolvimento).
    | NUNCA deixe true em produção!
    |
    */
    'disable_license_check' => env('MASTER_PANEL_DISABLE_CHECK', false),
];

