<?php
/**
 * Script para corrigir erro do Monolog/PSR Log
 * Execute este arquivo via navegador ou linha de comando
 * 
 * IMPORTANTE: Após executar, DELETE este arquivo por segurança!
 */

$isCli = php_sapi_name() === 'cli';

if (!$isCli) {
    echo "<!DOCTYPE html><html><head><meta charset='UTF-8'><title>Corrigir Monolog</title>";
    echo "<style>body{font-family:Arial;max-width:800px;margin:50px auto;padding:20px;}pre{background:#f5f5f5;padding:15px;border-radius:5px;overflow-x:auto;}</style></head><body>";
    echo "<h1>Corrigindo Erro Monolog/PSR Log</h1>";
    echo "<pre>";
}

$rootDir = __DIR__;

echo "🔧 Corrigindo conflito Monolog/PSR Log...\n";
echo str_repeat("=", 50) . "\n\n";

// Procurar composer
$composerPath = null;
$possiblePaths = [
    $rootDir . '/composer.phar',
    '/usr/local/bin/composer',
    '/usr/bin/composer',
    '/opt/alt/php82/usr/bin/composer',
    '/opt/cpanel/ea-php82/root/usr/bin/composer',
    'composer'
];

foreach ($possiblePaths as $path) {
    if ($path === 'composer') {
        $output = [];
        $return = 0;
        exec('composer --version 2>&1', $output, $return);
        if ($return === 0) {
            $composerPath = 'composer';
            break;
        }
    } elseif (file_exists($path)) {
        $composerPath = $path;
        break;
    }
}

if (!$composerPath) {
    // Tentar baixar composer.phar
    echo "⚠️  Composer não encontrado. Tentando baixar...\n";
    $composerPhar = $rootDir . '/composer.phar';
    $ch = curl_init('https://getcomposer.org/download/latest-stable/composer.phar');
    $fp = fopen($composerPhar, 'w');
    curl_setopt($ch, CURLOPT_FILE, $fp);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 300);
    
    if (curl_exec($ch) && curl_getinfo($ch, CURLINFO_HTTP_CODE) === 200) {
        chmod($composerPhar, 0755);
        $composerPath = "php " . escapeshellarg($composerPhar);
    } else {
        die("❌ Não foi possível baixar o Composer. Execute manualmente via SSH.\n");
    }
    curl_close($ch);
    fclose($fp);
} else {
    $composerPath = "php " . escapeshellarg($composerPath);
}

echo "✅ Composer encontrado\n\n";

// Passo 1: Remover vendor
echo "1️⃣ Removendo vendor/...\n";
if (is_dir($rootDir . '/vendor')) {
    // Tentar remover
    $output = [];
    exec("rm -rf " . escapeshellarg($rootDir . '/vendor') . " 2>&1", $output, $return);
    if ($return === 0) {
        echo "✅ vendor/ removido\n\n";
    } else {
        echo "⚠️  Não foi possível remover vendor/ automaticamente\n";
        echo "Execute manualmente: rm -rf vendor/\n\n";
    }
} else {
    echo "✅ vendor/ já não existe\n\n";
}

// Passo 2: Atualizar composer.json para forçar versões compatíveis
echo "2️⃣ Verificando composer.json...\n";
$composerJson = json_decode(file_get_contents($rootDir . '/composer.json'), true);

if (!$composerJson) {
    die("❌ Erro ao ler composer.json\n");
}

// Adicionar/atualizar versões compatíveis
$updated = false;
if (!isset($composerJson['require']['psr/log']) || version_compare($composerJson['require']['psr/log'], '^3.0', '<')) {
    $composerJson['require']['psr/log'] = '^3.0';
    $updated = true;
}

// Garantir que monolog está na versão 3.x
if (isset($composerJson['require']['monolog/monolog'])) {
    if (strpos($composerJson['require']['monolog/monolog'], '^3') === false && 
        strpos($composerJson['require']['monolog/monolog'], '~3') === false) {
        $composerJson['require']['monolog/monolog'] = '^3.0';
        $updated = true;
    }
} else {
    // Laravel geralmente já inclui monolog, mas vamos garantir
    $composerJson['require']['monolog/monolog'] = '^3.0';
    $updated = true;
}

if ($updated) {
    file_put_contents($rootDir . '/composer.json', json_encode($composerJson, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
    echo "✅ composer.json atualizado com versões compatíveis\n\n";
} else {
    echo "✅ composer.json já está correto\n\n";
}

// Passo 3: Instalar dependências
echo "3️⃣ Instalando dependências...\n";
echo str_repeat("-", 50) . "\n";

$command = $composerPath . " install --no-dev --optimize-autoloader 2>&1";
$output = [];
$returnCode = 0;

exec($command, $output, $returnCode);

foreach ($output as $line) {
    echo $line . "\n";
}

echo "\n" . str_repeat("=", 50) . "\n";

if ($returnCode === 0) {
    echo "\n✅ Dependências instaladas com sucesso!\n";
    
    // Verificar se vendor/autoload.php existe
    if (file_exists($rootDir . '/vendor/autoload.php')) {
        echo "✅ vendor/autoload.php criado\n";
        
        // Verificar versões instaladas
        echo "\n📦 Verificando versões instaladas...\n";
        $output = [];
        exec($composerPath . " show psr/log monolog/monolog 2>&1", $output, $return);
        foreach ($output as $line) {
            echo $line . "\n";
        }
        
        echo "\n🎉 Correção concluída!\n";
        echo "⚠️  IMPORTANTE: Delete este arquivo (fix-monolog.php) por segurança!\n";
    } else {
        echo "❌ Erro: vendor/autoload.php não foi criado\n";
    }
} else {
    echo "\n❌ Erro ao instalar dependências (código: $returnCode)\n";
    echo "\n💡 Tente executar manualmente via SSH:\n";
    echo "cd /home/canal33portal/public_html\n";
    echo "rm -rf vendor/\n";
    echo "composer install --no-dev --optimize-autoloader\n";
}

if (!$isCli) {
    echo "</pre>";
    echo "<p><strong>IMPORTANTE:</strong> Delete este arquivo após a correção!</p>";
    echo "</body></html>";
}

