// Widget de Clima
document.addEventListener('DOMContentLoaded', function() {
    const weatherTemp = document.getElementById('weather-temp');
    const weatherCity = document.querySelector('.weather-city');
    
    if (weatherTemp) {
        // Usar API de clima (exemplo com OpenWeatherMap)
        // Você pode configurar a cidade nas settings
        const city = 'Salvador'; // Pode vir das settings
        const apiKey = ''; // Configurar nas settings
        
        // Por enquanto, usar dados mockados ou API pública
        // Exemplo com API pública do Brasil
        fetch(`https://api.openweathermap.org/data/2.5/weather?q=${city},BR&appid=${apiKey}&units=metric&lang=pt_br`)
            .then(response => response.json())
            .then(data => {
                if (data.main) {
                    weatherTemp.textContent = Math.round(data.main.temp) + '°C';
                    if (weatherCity) {
                        weatherCity.textContent = data.name;
                    }
                }
            })
            .catch(error => {
                console.error('Erro ao carregar clima:', error);
                // Fallback
                weatherTemp.textContent = '25°C';
                if (weatherCity) {
                    weatherCity.textContent = city;
                }
            });
    }
});

