@extends('admin.layouts.app')

@section('title', 'Cadastrar Campanha de Anúncio')

@section('content')
<div class="ads-form-container">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Cadastrar Campanha de Anúncio</h2>
        <a href="{{ route('admin.ads.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Voltar
        </a>
    </div>

    <form action="{{ route('admin.ads.store') }}" method="POST" enctype="multipart/form-data">
        @csrf

        <!-- Informações Básicas -->
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">Informações Básicas</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Nome da Campanha <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control" value="{{ old('name') }}" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Usuário (Anunciante)</label>
                            <input type="text" class="form-control" value="{{ Auth::user()->name }}" disabled>
                            <input type="hidden" name="user_id" value="{{ Auth::id() }}">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Posição e Localização -->
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">Posição e Localização</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Posição <span class="text-danger">*</span></label>
                            <select name="position_id" class="form-select" required id="positionSelect">
                                <option value="">Selecione...</option>
                                @foreach($positions as $position)
                                    <option value="{{ $position->id }}" data-size="{{ $position->width }}x{{ $position->height }}" {{ old('position_id') == $position->id ? 'selected' : '' }}>
                                        {{ $position->name }} ({{ $position->width }}x{{ $position->height }})
                                    </option>
                                @endforeach
                            </select>
                            <small class="text-muted" id="positionSize"></small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Local/Alvo <span class="text-danger">*</span></label>
                            <select name="target" class="form-select" required id="targetSelect">
                                <option value="all" {{ old('target', 'all') == 'all' ? 'selected' : '' }}>Todo o Site</option>
                                <option value="home" {{ old('target') == 'home' ? 'selected' : '' }}>Somente Home</option>
                                <option value="pages" {{ old('target') == 'pages' ? 'selected' : '' }}>Páginas Específicas</option>
                                <option value="municipality" {{ old('target') == 'municipality' ? 'selected' : '' }}>Município</option>
                                <option value="blog" {{ old('target') == 'blog' ? 'selected' : '' }}>Blog</option>
                                <option value="column" {{ old('target') == 'column' ? 'selected' : '' }}>Coluna</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row" id="targetPagesContainer" style="display: none;">
                    <div class="col-md-12">
                        <div class="mb-3">
                            <label class="form-label">Páginas Específicas</label>
                            <select name="target_pages[]" class="form-select" multiple>
                                <!-- Adicionar páginas se existir -->
                            </select>
                            <small class="text-muted">Selecione as páginas onde o anúncio aparecerá</small>
                        </div>
                    </div>
                </div>

                <div class="row" id="targetMunicipalityContainer" style="display: none;">
                    <div class="col-md-12">
                        <div class="mb-3">
                            <label class="form-label">Município</label>
                            <select name="target_municipality_id" class="form-select">
                                <option value="">Selecione...</option>
                                <!-- Adicionar municípios se existir -->
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row" id="targetBlogContainer" style="display: none;">
                    <div class="col-md-12">
                        <div class="mb-3">
                            <label class="form-label">Blog</label>
                            <select name="target_blog_id" class="form-select">
                                <option value="">Selecione...</option>
                                <!-- Adicionar blogs se existir -->
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row" id="targetColumnContainer" style="display: none;">
                    <div class="col-md-12">
                        <div class="mb-3">
                            <label class="form-label">Coluna</label>
                            <input type="text" name="target_column" class="form-control" value="{{ old('target_column') }}" placeholder="Nome da coluna">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Formato e Conteúdo -->
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">Formato e Conteúdo</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label">Formato <span class="text-danger">*</span></label>
                            <select name="format" class="form-select" required id="formatSelect">
                                <option value="image" {{ old('format', 'image') == 'image' ? 'selected' : '' }}>Imagem</option>
                                <option value="html" {{ old('format') == 'html' ? 'selected' : '' }}>HTML (raw)</option>
                                <option value="script" {{ old('format') == 'script' ? 'selected' : '' }}>Script (ad network)</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div id="imageFormatContainer">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Upload da Criativa</label>
                                <input type="file" name="image" class="form-control" accept="image/*" id="imageInput">
                                <small class="text-muted">Formatos: JPG, PNG, GIF. Tamanho máximo: 2MB</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Link de Destino</label>
                                <input type="url" name="link" class="form-control" value="{{ old('link') }}" placeholder="https://...">
                            </div>
                        </div>
                    </div>
                    <div id="imagePreview" class="mb-3" style="display: none;">
                        <img src="" alt="Preview" class="img-thumbnail" style="max-width: 300px;">
                    </div>
                </div>

                <div id="htmlFormatContainer" style="display: none;">
                    <div class="mb-3">
                        <label class="form-label">Código HTML</label>
                        <textarea name="content" class="form-control" rows="10" placeholder="Cole o código HTML aqui...">{{ old('content') }}</textarea>
                    </div>
                </div>

                <div id="scriptFormatContainer" style="display: none;">
                    <div class="mb-3">
                        <label class="form-label">Código Script (Ad Network)</label>
                        <textarea name="content" class="form-control" rows="10" placeholder="Cole o código do script aqui...">{{ old('content') }}</textarea>
                        <small class="text-muted">Ex: Google AdSense, Media.net, etc.</small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Período e Limites -->
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">Período e Limites</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label">Data Início</label>
                            <input type="date" name="start_date" class="form-control" value="{{ old('start_date', date('Y-m-d')) }}">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label">Data Fim</label>
                            <input type="date" name="end_date" class="form-control" value="{{ old('end_date') }}">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label">Status</label>
                            <select name="status" class="form-select" required>
                                <option value="active" {{ old('status', 'active') == 'active' ? 'selected' : '' }}>Ativo</option>
                                <option value="paused" {{ old('status') == 'paused' ? 'selected' : '' }}>Pausado</option>
                                <option value="finished" {{ old('status') == 'finished' ? 'selected' : '' }}>Finalizado</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label class="form-label">Frequência</label>
                            <input type="number" name="frequency" class="form-control" value="{{ old('frequency') }}" min="1" placeholder="Ex: 1">
                            <small class="text-muted">Exibir a cada X visualizações</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label class="form-label">Rotações</label>
                            <input type="number" name="rotations" class="form-control" value="{{ old('rotations') }}" min="1" placeholder="Ex: 3">
                            <small class="text-muted">Número de rotações</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label class="form-label">Limite de Impressões</label>
                            <input type="number" name="impressions_limit" class="form-control" value="{{ old('impressions_limit') }}" min="0" placeholder="Opcional">
                            <small class="text-muted">Deixe em branco para ilimitado</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label class="form-label">Limite de Cliques</label>
                            <input type="number" name="clicks_limit" class="form-control" value="{{ old('clicks_limit') }}" min="0" placeholder="Opcional">
                            <small class="text-muted">Deixe em branco para ilimitado</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-check-circle"></i> Salvar Campanha
            </button>
            <a href="{{ route('admin.ads.index') }}" class="btn btn-secondary">Cancelar</a>
        </div>
    </form>
</div>

@endsection

@push('scripts')
<script>
    // Mostrar tamanho da posição
    document.getElementById('positionSelect').addEventListener('change', function() {
        const option = this.options[this.selectedIndex];
        const size = option.getAttribute('data-size');
        document.getElementById('positionSize').textContent = size ? `Tamanho: ${size}px` : '';
    });

    // Toggle containers baseado no formato
    document.getElementById('formatSelect').addEventListener('change', function() {
        const format = this.value;
        document.getElementById('imageFormatContainer').style.display = format === 'image' ? 'block' : 'none';
        document.getElementById('htmlFormatContainer').style.display = format === 'html' ? 'block' : 'none';
        document.getElementById('scriptFormatContainer').style.display = format === 'script' ? 'block' : 'none';
    });

    // Toggle containers baseado no alvo
    document.getElementById('targetSelect').addEventListener('change', function() {
        const target = this.value;
        document.getElementById('targetPagesContainer').style.display = target === 'pages' ? 'block' : 'none';
        document.getElementById('targetMunicipalityContainer').style.display = target === 'municipality' ? 'block' : 'none';
        document.getElementById('targetBlogContainer').style.display = target === 'blog' ? 'block' : 'none';
        document.getElementById('targetColumnContainer').style.display = target === 'column' ? 'block' : 'none';
    });

    // Preview da imagem
    document.getElementById('imageInput')?.addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                const preview = document.getElementById('imagePreview');
                preview.querySelector('img').src = e.target.result;
                preview.style.display = 'block';
            };
            reader.readAsDataURL(file);
        }
    });

    // Inicializar
    document.getElementById('formatSelect').dispatchEvent(new Event('change'));
    document.getElementById('targetSelect').dispatchEvent(new Event('change'));
</script>
@endpush

