@extends('admin.layouts.app')

@section('title', 'Gerir Posições de Anúncios')

@section('content')
<div class="ad-positions-container">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Gerir Posições de Anúncios</h2>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#positionModal" onclick="openPositionModal()">
            <i class="bi bi-plus-circle"></i> Nova Posição
        </button>
    </div>

    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Posições Disponíveis</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Tamanho</th>
                            <th>Slug</th>
                            <th>Descrição</th>
                            <th>Status</th>
                            <th>Campanhas</th>
                            <th width="150">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($positions as $position)
                        <tr>
                            <td><strong>{{ $position->name }}</strong></td>
                            <td>
                                <span class="badge badge-info">{{ $position->width }}x{{ $position->height }}px</span>
                            </td>
                            <td><code>{{ $position->slug }}</code></td>
                            <td><small class="text-muted">{{ $position->description }}</small></td>
                            <td>
                                @if($position->status === 'active')
                                    <span class="badge badge-success">Ativo</span>
                                @else
                                    <span class="badge badge-secondary">Inativo</span>
                                @endif
                            </td>
                            <td>
                                <span class="badge badge-primary">{{ $position->campaigns()->count() }}</span>
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <button type="button" class="btn btn-outline-primary" onclick="openPositionModal({{ $position->id }})">
                                        <i class="bi bi-pencil"></i>
                                    </button>
                                    <button type="button" class="btn btn-outline-danger" onclick="deletePosition({{ $position->id }})">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="text-center py-4">
                                <p class="text-muted mb-0">Nenhuma posição encontrada</p>
                                <button type="button" class="btn btn-primary mt-2" onclick="createDefaultPositions()">
                                    <i class="bi bi-magic"></i> Criar Posições Padrão
                                </button>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Modal Posição -->
<div class="modal fade" id="positionModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="positionModalTitle">Nova Posição</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="positionForm" method="POST">
                @csrf
                <div id="positionFormMethod"></div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Nome <span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control" required id="positionName">
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Largura (px) <span class="text-danger">*</span></label>
                                <input type="number" name="width" class="form-control" required id="positionWidth" min="1">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Altura (px) <span class="text-danger">*</span></label>
                                <input type="number" name="height" class="form-control" required id="positionHeight" min="1">
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Descrição</label>
                        <textarea name="description" class="form-control" rows="2" id="positionDescription"></textarea>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select" required id="positionStatus">
                            <option value="active">Ativo</option>
                            <option value="inactive">Inativo</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Salvar</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
    let editingPositionId = null;

    function openPositionModal(positionId = null) {
        editingPositionId = positionId;
        const form = document.getElementById('positionForm');
        const title = document.getElementById('positionModalTitle');
        const methodInput = document.getElementById('positionFormMethod');

        if (positionId) {
            title.textContent = 'Editar Posição';
            form.action = `{{ route('admin.ads.positions') }}/${positionId}`;
            methodInput.innerHTML = '@method("PUT")';
            
            fetch(`{{ route('admin.ads.positions') }}/${positionId}`)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('positionName').value = data.name;
                    document.getElementById('positionWidth').value = data.width;
                    document.getElementById('positionHeight').value = data.height;
                    document.getElementById('positionDescription').value = data.description || '';
                    document.getElementById('positionStatus').value = data.status;
                });
        } else {
            title.textContent = 'Nova Posição';
            form.action = '{{ route('admin.ads.positions') }}';
            methodInput.innerHTML = '';
            form.reset();
        }
    }

    function deletePosition(id) {
        if (confirm('Deseja realmente excluir esta posição?')) {
            fetch(`{{ route('admin.ads.positions') }}/${id}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                }
            });
        }
    }

    function createDefaultPositions() {
        if (confirm('Deseja criar as posições padrão de anúncios?')) {
            fetch('{{ route('admin.ads.positions') }}/create-default', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                }
            });
        }
    }
</script>
@endpush

