@extends('admin.layouts.app')

@section('title', 'AutoPost - Notícias Automáticas')

@section('content')
<div class="autopost-container">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>AutoPost - Notícias Automáticas</h2>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#jobModal" onclick="openJobModal()">
            <i class="bi bi-plus-circle"></i> Novo Job
        </button>
    </div>

    <!-- Jobs Ativos -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0">Jobs de Importação ({{ $jobs->count() }})</h5>
        </div>
        <div class="card-body">
            @if($jobs->count() > 0)
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Provedor</th>
                            <th>Tipo</th>
                            <th>Frequência</th>
                            <th>Categoria</th>
                            <th>Última Execução</th>
                            <th>Importadas</th>
                            <th>Status</th>
                            <th width="200">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($jobs as $job)
                        <tr>
                            <td>
                                <strong>{{ $job->provider_name }}</strong>
                                <br>
                                <small class="text-muted">{{ Str::limit($job->provider_url, 50) }}</small>
                            </td>
                            <td>
                                <span class="badge badge-info">{{ ucfirst($job->provider_type) }}</span>
                            </td>
                            <td>
                                A cada {{ $job->frequency }} min
                            </td>
                            <td>
                                {{ $job->category->name ?? '-' }}
                            </td>
                            <td>
                                @if($job->last_run_at)
                                    <small>{{ $job->last_run_at->diffForHumans() }}</small>
                                    <br>
                                    <small class="text-muted">{{ $job->last_imported ?? 0 }} importadas</small>
                                @else
                                    <small class="text-muted">Nunca executado</small>
                                @endif
                            </td>
                            <td>
                                <span class="badge badge-success">{{ $job->last_imported ?? 0 }}</span>
                            </td>
                            <td>
                                @if($job->status === 'active')
                                    <span class="badge badge-success">Ativo</span>
                                @else
                                    <span class="badge badge-secondary">Inativo</span>
                                @endif
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <button type="button" class="btn btn-outline-primary" onclick="openJobModal({{ $job->id }})">
                                        <i class="bi bi-pencil"></i>
                                    </button>
                                    <a href="{{ route('admin.autopost.run', $job->id) }}" 
                                       class="btn btn-outline-success" 
                                       onclick="return confirm('Executar importação agora?')"
                                       title="Executar Agora">
                                        <i class="bi bi-play"></i>
                                    </a>
                                    <a href="{{ route('admin.autopost.logs', $job->id) }}" 
                                       class="btn btn-outline-info"
                                       title="Ver Logs">
                                        <i class="bi bi-list-ul"></i>
                                    </a>
                                    <form action="{{ route('admin.autopost.destroy', $job->id) }}" 
                                          method="POST" 
                                          style="display: inline;"
                                          onsubmit="return confirm('Deseja excluir este job?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-outline-danger">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            @else
            <p class="text-muted text-center py-4">Nenhum job configurado</p>
            @endif
        </div>
    </div>

    <!-- Provedores Disponíveis -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Provedores Disponíveis ({{ count($providers) }})</h5>
        </div>
        <div class="card-body">
            <div class="row">
                @foreach($providers as $provider)
                <div class="col-md-3 mb-3">
                    <div class="card h-100">
                        <div class="card-body">
                            <h6 class="card-title">{{ $provider['name'] }}</h6>
                            <p class="card-text">
                                <small class="text-muted">{{ $provider['category'] ?? 'Geral' }}</small>
                                <br>
                                <small><strong>Região:</strong> {{ $provider['region'] ?? 'Brasil' }}</small>
                            </p>
                            <button type="button" 
                                    class="btn btn-sm btn-primary w-100" 
                                    onclick="useProvider({{ json_encode($provider) }})">
                                <i class="bi bi-plus"></i> Usar Este Provedor
                            </button>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</div>

<!-- Modal Job -->
<div class="modal fade" id="jobModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="jobModalTitle">Novo Job de AutoPost</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="jobForm" method="POST">
                @csrf
                <div id="jobFormMethod"></div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Nome do Provedor <span class="text-danger">*</span></label>
                                <input type="text" name="provider_name" class="form-control" required id="providerName">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Tipo de Adapter <span class="text-danger">*</span></label>
                                <select name="provider_type" class="form-select" required id="providerType">
                                    <option value="">Selecione...</option>
                                    <option value="rss">RSS Feed</option>
                                    <option value="dino">Dino API</option>
                                    <option value="agencia_x">Agência X</option>
                                    <option value="custom">Custom</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">URL do Provedor <span class="text-danger">*</span></label>
                        <input type="url" name="provider_url" class="form-control" required id="providerUrl" placeholder="https://...">
                    </div>

                    <div id="apiKeyContainer" style="display: none;">
                        <div class="mb-3">
                            <label class="form-label">API Key</label>
                            <input type="text" name="provider_config[api_key]" class="form-control" id="apiKey" placeholder="Chave da API">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label class="form-label">Frequência (minutos) <span class="text-danger">*</span></label>
                                <select name="frequency" class="form-select" required>
                                    <option value="10">A cada 10 minutos</option>
                                    <option value="20">A cada 20 minutos</option>
                                    <option value="30" selected>A cada 30 minutos</option>
                                    <option value="60">A cada 1 hora</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label class="form-label">Quantidade por Importação <span class="text-danger">*</span></label>
                                <input type="number" name="max_import" class="form-control" value="5" min="1" max="10" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label class="form-label">Categoria Padrão <span class="text-danger">*</span></label>
                                <select name="default_category_id" class="form-select" required>
                                    @foreach($categories as $category)
                                        <option value="{{ $category->id }}">{{ $category->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="create_category_if_not_exists" value="1" id="createCategory">
                            <label class="form-check-label" for="createCategory">
                                Criar categoria automaticamente se não existir
                            </label>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label class="form-label">Publicar Automaticamente</label>
                                <select name="auto_publish" class="form-select" required>
                                    <option value="draft" selected>Apenas Rascunho</option>
                                    <option value="published">Publicar Automaticamente</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label class="form-label">Status</label>
                                <select name="status" class="form-select" required>
                                    <option value="active" selected>Ativo</option>
                                    <option value="inactive">Inativo</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="send_notifications" value="1" id="sendNotifications">
                            <label class="form-check-label" for="sendNotifications">
                                Enviar Notificações (Push/WhatsApp)
                            </label>
                        </div>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="publish_social" value="1" id="publishSocial">
                            <label class="form-check-label" for="publishSocial">
                                Publicar no Instagram/Facebook
                            </label>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Salvar Job</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
    let editingJobId = null;

    function openJobModal(jobId = null) {
        editingJobId = jobId;
        const form = document.getElementById('jobForm');
        const title = document.getElementById('jobModalTitle');
        const methodInput = document.getElementById('jobFormMethod');

        if (jobId) {
            title.textContent = 'Editar Job';
            form.action = `{{ route('admin.autopost.index') }}/${jobId}`;
            methodInput.innerHTML = '@method("PUT")';
            
            fetch(`{{ route('admin.autopost.index') }}/${jobId}`)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('providerName').value = data.provider_name;
                    document.getElementById('providerType').value = data.provider_type;
                    document.getElementById('providerUrl').value = data.provider_url;
                    if (data.provider_config?.api_key) {
                        document.getElementById('apiKey').value = data.provider_config.api_key;
                    }
                    // Preencher outros campos...
                });
        } else {
            title.textContent = 'Novo Job de AutoPost';
            form.action = '{{ route('admin.autopost.store') }}';
            methodInput.innerHTML = '';
            form.reset();
        }
    }

    function useProvider(provider) {
        document.getElementById('providerName').value = provider.name;
        document.getElementById('providerUrl').value = provider.url;
        document.getElementById('providerType').value = provider.type || 'rss';
        
        const modal = new bootstrap.Modal(document.getElementById('jobModal'));
        modal.show();
    }

    // Toggle API Key container
    document.getElementById('providerType')?.addEventListener('change', function() {
        const needsApiKey = ['dino', 'agencia_x'].includes(this.value);
        document.getElementById('apiKeyContainer').style.display = needsApiKey ? 'block' : 'none';
    });
</script>
@endpush

