@extends('admin.layouts.app')

@section('title', 'Logs do AutoPost: ' . $job->provider_name)

@section('content')
<div class="autopost-logs-container">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2>Logs do AutoPost</h2>
            <p class="text-muted mb-0">{{ $job->provider_name }}</p>
        </div>
        <a href="{{ route('admin.autopost.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Voltar
        </a>
    </div>

    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Histórico de Importações ({{ $logs->total() }})</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th>Data/Hora</th>
                            <th>Item</th>
                            <th>Status</th>
                            <th>Notícia</th>
                            <th>Erro</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($logs as $log)
                        <tr>
                            <td>
                                <small>{{ $log->created_at->format('d/m/Y H:i:s') }}</small>
                            </td>
                            <td>
                                <strong>{{ Str::limit($log->item_title, 60) }}</strong>
                                @if($log->item_url)
                                    <br>
                                    <a href="{{ $log->item_url }}" target="_blank" class="text-muted small">
                                        {{ Str::limit($log->item_url, 50) }}
                                    </a>
                                @endif
                            </td>
                            <td>
                                @if($log->status === 'success')
                                    <span class="badge badge-success">Sucesso</span>
                                @else
                                    <span class="badge badge-danger">Erro</span>
                                @endif
                            </td>
                            <td>
                                @if($log->news_id)
                                    <a href="{{ route('admin.news.edit', $log->news_id) }}" class="btn btn-sm btn-outline-primary">
                                        <i class="bi bi-eye"></i> Ver
                                    </a>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td>
                                @if($log->error_message)
                                    <small class="text-danger">{{ Str::limit($log->error_message, 100) }}</small>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="5" class="text-center py-4">
                                <p class="text-muted mb-0">Nenhum log encontrado</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if($logs->hasPages())
        <div class="card-footer">
            {{ $logs->links() }}
        </div>
        @endif
    </div>
</div>

@endsection

