@extends('admin.layouts.app')

@section('title', 'Dashboard')

@section('content')
<div class="dashboard-container">
    <!-- Widgets de Resumo -->
    <div class="dashboard-widgets">
        <div class="widget">
            <div class="widget-header">
                <span class="widget-title">Notícias Hoje</span>
                <div class="widget-icon">
                    <i class="bi bi-newspaper"></i>
                </div>
            </div>
            <div class="widget-value">{{ $stats['news_today'] }}</div>
            <div class="widget-footer">
                <i class="bi bi-arrow-up text-success"></i> Total: {{ $stats['news_total'] }}
            </div>
        </div>

        <div class="widget">
            <div class="widget-header">
                <span class="widget-title">Notícias Publicadas</span>
                <div class="widget-icon" style="background: rgba(16, 185, 129, 0.1); color: var(--success-color);">
                    <i class="bi bi-check-circle"></i>
                </div>
            </div>
            <div class="widget-value">{{ $stats['news_published'] }}</div>
            <div class="widget-footer">
                <i class="bi bi-eye"></i> Visíveis no site
            </div>
        </div>

        <div class="widget">
            <div class="widget-header">
                <span class="widget-title">Total de Vídeos</span>
                <div class="widget-icon" style="background: rgba(239, 68, 68, 0.1); color: var(--danger-color);">
                    <i class="bi bi-play-circle"></i>
                </div>
            </div>
            <div class="widget-value">{{ $stats['videos_total'] }}</div>
            <div class="widget-footer">
                <i class="bi bi-collection"></i> Vídeos cadastrados
            </div>
        </div>

        <div class="widget">
            <div class="widget-header">
                <span class="widget-title">Total de Galerias</span>
                <div class="widget-icon" style="background: rgba(245, 158, 11, 0.1); color: var(--warning-color);">
                    <i class="bi bi-images"></i>
                </div>
            </div>
            <div class="widget-value">{{ $stats['galleries_total'] }}</div>
            <div class="widget-footer">
                <i class="bi bi-folder"></i> Galerias criadas
            </div>
        </div>

        <div class="widget">
            <div class="widget-header">
                <span class="widget-title">Classificados Pendentes</span>
                <div class="widget-icon" style="background: rgba(245, 158, 11, 0.1); color: var(--warning-color);">
                    <i class="bi bi-hourglass-split"></i>
                </div>
            </div>
            <div class="widget-value">{{ $stats['classifieds_pending'] }}</div>
            <div class="widget-footer">
                <i class="bi bi-check-circle"></i> Ativos: {{ $stats['classifieds_active'] }}
            </div>
        </div>

        <div class="widget">
            <div class="widget-header">
                <span class="widget-title">Anúncios Ativos</span>
                <div class="widget-icon" style="background: rgba(16, 185, 129, 0.1); color: var(--success-color);">
                    <i class="bi bi-megaphone"></i>
                </div>
            </div>
            <div class="widget-value">{{ $stats['ads_active'] }}</div>
            <div class="widget-footer">
                <i class="bi bi-graph-up"></i> Campanhas ativas
            </div>
        </div>
    </div>

    <!-- Acesso Rápido -->
    <div class="card">
        <div class="card-header">
            <h5 class="card-title">Acesso Rápido</h5>
        </div>
        <div class="card-body">
            <div class="quick-actions">
                <a href="{{ route('admin.news.create') }}" class="quick-action-btn">
                    <i class="bi bi-plus-circle text-primary"></i>
                    <span>Cadastrar Notícia</span>
                </a>
                <a href="{{ route('admin.videos.create') }}" class="quick-action-btn">
                    <i class="bi bi-play-circle text-danger"></i>
                    <span>Cadastrar Vídeo</span>
                </a>
                <a href="{{ route('admin.galleries.create') }}" class="quick-action-btn">
                    <i class="bi bi-images text-warning"></i>
                    <span>Cadastrar Galeria</span>
                </a>
                <a href="{{ route('admin.ads.create') }}" class="quick-action-btn">
                    <i class="bi bi-megaphone text-success"></i>
                    <span>Cadastrar Anúncio</span>
                </a>
                <a href="{{ route('admin.settings.general') }}" class="quick-action-btn">
                    <i class="bi bi-palette text-info"></i>
                    <span>Personalizar Layout</span>
                </a>
                <a href="{{ route('admin.settings.index') }}" class="quick-action-btn">
                    <i class="bi bi-gear text-secondary"></i>
                    <span>Alterar Configuração</span>
                </a>
                <a href="{{ route('admin.plugins.index') }}" class="quick-action-btn">
                    <i class="bi bi-puzzle text-primary"></i>
                    <span>AutoPost (config)</span>
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Assuntos em Alta (Google Trends) -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Assuntos em Alta</h5>
                    <small class="text-muted">Google Trends - Brasil</small>
                </div>
                <div class="card-body">
                    @if(isset($trends) && count($trends) > 0)
                        <ul class="list-group list-group-flush">
                            @foreach($trends as $trend)
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>{{ $trend['title'] }}</strong>
                                    @if(isset($trend['traffic']))
                                        <br><small class="text-muted">{{ $trend['traffic'] }} buscas</small>
                                    @endif
                                </div>
                                <a href="{{ route('admin.news.create') }}?trend={{ urlencode($trend['title']) }}" 
                                   class="btn btn-sm btn-primary">
                                    <i class="bi bi-plus"></i> Criar Matéria
                                </a>
                            </li>
                            @endforeach
                        </ul>
                    @else
                        <p class="text-muted text-center py-3">Carregando tendências...</p>
                    @endif
                </div>
            </div>
        </div>

        <!-- Atividade Recente -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Atividade Recente</h5>
                </div>
                <div class="card-body">
                    <div class="activity-list">
                        <h6 class="text-muted mb-3">Últimas Publicações</h6>
                        @if(isset($recentNews) && $recentNews->count() > 0)
                            @foreach($recentNews as $news)
                            <div class="activity-item mb-3 pb-3 border-bottom">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <strong>{{ Str::limit($news->title, 50) }}</strong>
                                        <br>
                                        <small class="text-muted">
                                            <i class="bi bi-person"></i> {{ $news->user->name ?? 'Sistema' }}
                                            <i class="bi bi-clock ms-2"></i> {{ $news->created_at->diffForHumans() }}
                                        </small>
                                    </div>
                                    <span class="badge badge-{{ $news->status === 'published' ? 'success' : 'warning' }}">
                                        {{ ucfirst($news->status) }}
                                    </span>
                                </div>
                            </div>
                            @endforeach
                        @else
                            <p class="text-muted text-center py-3">Nenhuma atividade recente</p>
                        @endif

                        <h6 class="text-muted mb-3 mt-4">Últimos Usuários que Logaram</h6>
                        @if(isset($recentUsers) && $recentUsers->count() > 0)
                            @foreach($recentUsers as $user)
                            <div class="activity-item mb-2">
                                <div class="d-flex align-items-center gap-2">
                                    <i class="bi bi-person-circle"></i>
                                    <div>
                                        <strong>{{ $user->name }}</strong>
                                        <br>
                                        <small class="text-muted">{{ \Carbon\Carbon::parse($user->last_login)->diffForHumans() }}</small>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        @else
                            <p class="text-muted text-center py-3">Nenhum login recente</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Estatísticas e Avisos do Master -->
    <div class="row mt-4">
        <!-- Estatísticas -->
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Estatísticas</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4 text-center mb-3">
                            <div class="stat-box">
                                <i class="bi bi-eye text-primary" style="font-size: 2rem;"></i>
                                <h4 class="mt-2">0</h4>
                                <p class="text-muted">Acessos Hoje</p>
                            </div>
                        </div>
                        <div class="col-md-4 text-center mb-3">
                            <div class="stat-box">
                                <i class="bi bi-graph-up text-success" style="font-size: 2rem;"></i>
                                <h4 class="mt-2">0</h4>
                                <p class="text-muted">Tráfego Total</p>
                            </div>
                        </div>
                        <div class="col-md-4 text-center mb-3">
                            <div class="stat-box">
                                <i class="bi bi-star text-warning" style="font-size: 2rem;"></i>
                                <h4 class="mt-2">0</h4>
                                <p class="text-muted">Top Matérias</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Avisos do Master -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Avisos do Master</h5>
                </div>
                <div class="card-body">
                    @if(isset($updates) && count($updates) > 0)
                        @foreach($updates as $update)
                        <div class="alert alert-{{ $update['critical'] ? 'danger' : 'info' }} mb-2">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <strong>{{ $update['title'] }}</strong>
                                    <br>
                                    <small>Versão {{ $update['version'] }}</small>
                                </div>
                                @if($update['critical'])
                                    <span class="badge bg-danger">CRÍTICA</span>
                                @endif
                            </div>
                            <p class="mb-0 mt-2">{{ Str::limit($update['description'], 100) }}</p>
                            <a href="{{ $update['download_url'] ?? '#' }}" class="btn btn-sm btn-primary mt-2">
                                Ver Detalhes
                            </a>
                        </div>
                        @endforeach
                    @else
                        <p class="text-muted text-center py-3">Nenhum aviso do Master</p>
                    @endif

                    @if(isset($newPlugins) && count($newPlugins) > 0)
                        <h6 class="mt-3 mb-2">Plugins Novos</h6>
                        @foreach($newPlugins as $plugin)
                        <div class="alert alert-success mb-2">
                            <strong>{{ $plugin['name'] }}</strong>
                            <br>
                            <small>{{ $plugin['description'] }}</small>
                            <a href="{{ route('admin.plugins.index') }}" class="btn btn-sm btn-success mt-2">
                                Instalar
                            </a>
                        </div>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.stat-box {
    padding: 1rem;
    background: #f8fafc;
    border-radius: 8px;
}
</style>
@endpush

