@extends('admin.layouts.app')

@section('title', 'Cadastrar Notícia')

@section('content')
<div class="news-form-container">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Cadastrar Notícia</h2>
        <a href="{{ route('admin.news.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Voltar
        </a>
    </div>

    <form action="{{ route('admin.news.store') }}" method="POST" enctype="multipart/form-data" id="newsForm">
        @csrf

        <!-- Campos de Topo -->
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">Informações Básicas</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label class="form-label">Usuário</label>
                            <input type="text" class="form-control" value="{{ Auth::user()->name }}" disabled>
                            <input type="hidden" name="user_id" value="{{ Auth::id() }}">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label class="form-label">Categoria <span class="text-danger">*</span></label>
                            <select name="category_id" class="form-select" required>
                                <option value="">Selecione...</option>
                                @foreach($categories as $category)
                                    <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>
                                        {{ $category->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Checkboxes de Destaque</label>
                            <div class="d-flex flex-wrap gap-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="is_featured" id="is_featured" value="1" {{ old('is_featured') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_featured">Destaque</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="is_slide" id="is_slide" value="1" {{ old('is_slide') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_slide">Slide</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="is_headline" id="is_headline" value="1" {{ old('is_headline') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_headline">Manchete</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="is_more_news" id="is_more_news" value="1" {{ old('is_more_news') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_more_news">Sessão "Mais notícias"</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="is_urgent" id="is_urgent" value="1" {{ old('is_urgent') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_urgent">Notícia urgente 24h</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label">Chapéu</label>
                            <input type="text" name="hat" class="form-control" value="{{ old('hat') }}" placeholder="Ex: Política, Esportes...">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label">Fonte</label>
                            <input type="text" name="source" class="form-control" value="{{ old('source') }}" placeholder="Fonte da notícia">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label">Acesso</label>
                            <select name="access" class="form-select">
                                <option value="public" {{ old('access', 'public') == 'public' ? 'selected' : '' }}>Público</option>
                                <option value="subscriber" {{ old('access') == 'subscriber' ? 'selected' : '' }}>Assinante</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="mb-3">
                            <label class="form-label">Título <span class="text-danger">*</span></label>
                            <input type="text" name="title" class="form-control" value="{{ old('title', request('trend')) }}" required maxlength="255">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="mb-3">
                            <label class="form-label">Subtítulo</label>
                            <input type="text" name="subtitle" class="form-control" value="{{ old('subtitle') }}" maxlength="255">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label">Município</label>
                            <select name="municipality_id" class="form-select">
                                <option value="">Selecione...</option>
                                @foreach($municipalities as $municipality)
                                    <option value="{{ $municipality->id }}" {{ old('municipality_id') == $municipality->id ? 'selected' : '' }}>
                                        {{ $municipality->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label">Blog</label>
                            <select name="blog_id" class="form-select">
                                <option value="">Selecione...</option>
                                <!-- Adicionar blogs se existir -->
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label">Barra / Coluna</label>
                            <input type="text" name="column" class="form-control" value="{{ old('column') }}" placeholder="Nome da coluna">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Ferramentas Extras -->
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">Ferramentas Extras</h5>
            </div>
            <div class="card-body">
                <div class="d-flex gap-2 mb-3">
                    <button type="button" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#imageBankModal">
                        <i class="bi bi-image"></i> Banco de Imagem
                    </button>
                    <button type="button" class="btn btn-outline-primary" id="uploadMultipleImages">
                        <i class="bi bi-images"></i> Upload Múltiplo de Imagens
                    </button>
                    <button type="button" class="btn btn-outline-primary" id="uploadPdf">
                        <i class="bi bi-file-pdf"></i> Upload PDF (anexo)
                    </button>
                </div>
            </div>
        </div>

        <!-- Foto de Capa -->
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">Foto de Capa</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Upload da Imagem de Capa</label>
                            <input type="file" name="cover_image" class="form-control" accept="image/*" id="coverImageInput">
                            <small class="text-muted">Formatos: JPG, PNG, GIF. Tamanho máximo: 2MB</small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Descrição de Crédito</label>
                            <input type="text" name="image_credit" class="form-control" value="{{ old('image_credit') }}" placeholder="Crédito da imagem">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label">Largura da Imagem</label>
                            <select name="image_width" class="form-select">
                                <option value="auto" {{ old('image_width', 'auto') == 'auto' ? 'selected' : '' }}>Automático</option>
                                <option value="full" {{ old('image_width') == 'full' ? 'selected' : '' }}>Largura Total</option>
                                <option value="half" {{ old('image_width') == 'half' ? 'selected' : '' }}>Metade</option>
                                <option value="third" {{ old('image_width') == 'third' ? 'selected' : '' }}>Um Terço</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label">Criar galeria?</label>
                            <select name="create_gallery" class="form-select" id="createGallerySelect">
                                <option value="no" {{ old('create_gallery', 'no') == 'no' ? 'selected' : '' }}>Não</option>
                                <option value="yes" {{ old('create_gallery') == 'yes' ? 'selected' : '' }}>Sim</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4" id="gallerySelectContainer" style="display: none;">
                        <div class="mb-3">
                            <label class="form-label">Galeria de Fotos</label>
                            <select name="gallery_id" class="form-select">
                                <option value="">Selecione...</option>
                                @foreach($galleries as $gallery)
                                    <option value="{{ $gallery->id }}" {{ old('gallery_id') == $gallery->id ? 'selected' : '' }}>
                                        {{ $gallery->title }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <div id="coverImagePreview" class="mt-3" style="display: none;">
                    <img src="" alt="Preview" class="img-thumbnail" style="max-width: 300px;">
                </div>
            </div>
        </div>

        <!-- Data e Hora de Publicação -->
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">Data e Hora de Publicação</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Data de Publicação</label>
                            <input type="date" name="published_date" class="form-control" value="{{ old('published_date', date('Y-m-d')) }}">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Hora de Publicação</label>
                            <input type="time" name="published_time" class="form-control" value="{{ old('published_time', date('H:i')) }}">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Publicação em Redes Sociais -->
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">Publicação em Redes Sociais</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="publish_instagram" id="publish_instagram" value="1" {{ old('publish_instagram') ? 'checked' : '' }}>
                                <label class="form-check-label" for="publish_instagram">Publicar no Instagram?</label>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="publish_instagram_stories" id="publish_instagram_stories" value="1" {{ old('publish_instagram_stories') ? 'checked' : '' }}>
                                <label class="form-check-label" for="publish_instagram_stories">Publicar no Stories?</label>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="publish_facebook" id="publish_facebook" value="1" {{ old('publish_facebook') ? 'checked' : '' }}>
                                <label class="form-check-label" for="publish_facebook">Publicar no Facebook?</label>
                            </div>
                        </div>
                        <div class="mb-3" id="facebookCaptionContainer" style="display: none;">
                            <label class="form-label">Descrição para Post no Facebook</label>
                            <textarea name="facebook_caption" class="form-control" rows="3" placeholder="Texto que aparecerá no post do Facebook">{{ old('facebook_caption') }}</textarea>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="push_notification" id="push_notification" value="1" {{ old('push_notification') ? 'checked' : '' }}>
                                <label class="form-check-label" for="push_notification">Notificação Push?</label>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="whatsapp_notification" id="whatsapp_notification" value="1" {{ old('whatsapp_notification') ? 'checked' : '' }}>
                                <label class="form-check-label" for="whatsapp_notification">Notificação WhatsApp?</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Texto do Corpo -->
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">Texto do Corpo</h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <label class="form-label">Conteúdo <span class="text-danger">*</span></label>
                    <div id="editor" style="height: 400px;"></div>
                    <textarea name="body" id="body" style="display: none;" required>{{ old('body') }}</textarea>
                </div>
                <div class="d-flex gap-2">
                    <button type="button" class="btn btn-sm btn-outline-primary" id="insertAdButton">
                        <i class="bi bi-megaphone"></i> Inserir Anúncio entre Parágrafos
                    </button>
                </div>
            </div>
        </div>

        <!-- SEO -->
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">SEO</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label">Slug</label>
                            <input type="text" name="slug" class="form-control" value="{{ old('slug') }}" id="slugInput" placeholder="sera-gerado-automaticamente">
                            <small class="text-muted">Deixe em branco para gerar automaticamente</small>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label">Meta Title</label>
                            <input type="text" name="meta_title" class="form-control" value="{{ old('meta_title') }}" maxlength="60">
                            <small class="text-muted">Máximo 60 caracteres</small>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label">Canonical URL</label>
                            <input type="url" name="canonical_url" class="form-control" value="{{ old('canonical_url') }}" placeholder="https://...">
                        </div>
                    </div>
                </div>
                <div class="mb-3">
                    <label class="form-label">Meta Description</label>
                    <textarea name="meta_description" class="form-control" rows="3" maxlength="160">{{ old('meta_description') }}</textarea>
                    <small class="text-muted">Máximo 160 caracteres</small>
                </div>
            </div>
        </div>

        <!-- Tags -->
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">Tags</h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <label class="form-label">Tags (múltipla seleção)</label>
                    <select name="tags[]" class="form-select" id="tagsSelect" multiple>
                        @foreach($tags as $tag)
                            <option value="{{ $tag->id }}" {{ in_array($tag->id, old('tags', [])) ? 'selected' : '' }}>
                                {{ $tag->name }}
                            </option>
                        @endforeach
                    </select>
                    <small class="text-muted">Use Ctrl/Cmd para selecionar múltiplas tags</small>
                </div>
            </div>
        </div>

        <!-- Status e Ações -->
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">Status e Ações</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label">Status</label>
                            <select name="status" class="form-select" required>
                                <option value="draft" {{ old('status', 'draft') == 'draft' ? 'selected' : '' }}>Rascunho</option>
                                <option value="scheduled" {{ old('status') == 'scheduled' ? 'selected' : '' }}>Agendado</option>
                                <option value="published" {{ old('status') == 'published' ? 'selected' : '' }}>Publicado</option>
                                <option value="pending_review" {{ old('status') == 'pending_review' ? 'selected' : '' }}>Pendente Revisão</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="d-flex gap-2">
                    <button type="submit" name="action" value="save_draft" class="btn btn-secondary">
                        <i class="bi bi-save"></i> Salvar Rascunho
                    </button>
                    <button type="button" class="btn btn-info" id="previewButton">
                        <i class="bi bi-eye"></i> Visualizar
                    </button>
                    <button type="submit" name="action" value="publish" class="btn btn-success">
                        <i class="bi bi-check-circle"></i> Publicar
                    </button>
                    <button type="submit" name="action" value="schedule" class="btn btn-warning">
                        <i class="bi bi-clock"></i> Agendar
                    </button>
                    <button type="button" class="btn btn-primary" id="generatePostButton">
                        <i class="bi bi-share"></i> Gerar Post (SocialPost)
                    </button>
                </div>
            </div>
        </div>
    </form>
</div>

<!-- Modal Banco de Imagens -->
<div class="modal fade" id="imageBankModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Banco de Imagens</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p class="text-muted">Funcionalidade de banco de imagens será implementada.</p>
            </div>
        </div>
    </div>
</div>

@endsection

@push('styles')
<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
<style>
    .ql-editor {
        min-height: 300px;
    }
</style>
@endpush

@push('scripts')
<script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
<script>
    // Inicializar editor Quill
    var quill = new Quill('#editor', {
        theme: 'snow',
        modules: {
            toolbar: [
                [{ 'header': [1, 2, 3, false] }],
                ['bold', 'italic', 'underline', 'strike'],
                [{ 'list': 'ordered'}, { 'list': 'bullet' }],
                ['link', 'image'],
                ['clean']
            ]
        }
    });

    // Sincronizar conteúdo do editor com textarea
    quill.on('text-change', function() {
        document.getElementById('body').value = quill.root.innerHTML;
    });

    // Carregar conteúdo inicial se existir
    @if(old('body'))
        quill.root.innerHTML = {!! json_encode(old('body')) !!};
    @endif

    // Preview da imagem de capa
    document.getElementById('coverImageInput').addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                const preview = document.getElementById('coverImagePreview');
                preview.querySelector('img').src = e.target.result;
                preview.style.display = 'block';
            };
            reader.readAsDataURL(file);
        }
    });

    // Toggle galeria
    document.getElementById('createGallerySelect').addEventListener('change', function() {
        document.getElementById('gallerySelectContainer').style.display = 
            this.value === 'yes' ? 'block' : 'none';
    });

    // Toggle Facebook caption
    document.getElementById('publish_facebook').addEventListener('change', function() {
        document.getElementById('facebookCaptionContainer').style.display = 
            this.checked ? 'block' : 'none';
    });

    // Gerar slug automaticamente
    document.querySelector('input[name="title"]').addEventListener('input', function() {
        if (!document.getElementById('slugInput').value) {
            const slug = this.value.toLowerCase()
                .normalize('NFD')
                .replace(/[\u0300-\u036f]/g, '')
                .replace(/[^a-z0-9]+/g, '-')
                .replace(/(^-|-$)/g, '');
            document.getElementById('slugInput').value = slug;
        }
    });

    // Select2 para tags
    $('#tagsSelect').select2({
        placeholder: 'Selecione as tags',
        width: '100%'
    });

    // Inserir anúncio
    document.getElementById('insertAdButton').addEventListener('click', function() {
        const range = quill.getSelection();
        if (range) {
            quill.insertText(range.index, '\n[ANÚNCIO]\n', 'user');
        } else {
            quill.insertText(quill.getLength(), '\n[ANÚNCIO]\n', 'user');
        }
    });

    // Gerar post SocialPost
    document.getElementById('generatePostButton').addEventListener('click', function() {
        // Implementar integração com plugin SocialPost
        alert('Funcionalidade do plugin SocialPost será implementada.');
    });
</script>
@endpush

