@extends('admin.layouts.app')

@section('title', 'Lista de Notícias')

@section('content')
<div class="news-list-container">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Lista de Notícias</h2>
        <a href="{{ route('admin.news.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Cadastrar Notícia
        </a>
    </div>

    <!-- Filtros -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0">Filtros de Busca</h5>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('admin.news.index') }}" id="filterForm">
                <div class="row">
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label class="form-label">Pesquisar</label>
                            <input type="text" name="search" class="form-control" 
                                   value="{{ request('search') }}" 
                                   placeholder="Título, conteúdo...">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="mb-3">
                            <label class="form-label">Categoria</label>
                            <select name="category_id" class="form-select">
                                <option value="">Todas</option>
                                @foreach($categories as $category)
                                    <option value="{{ $category->id }}" {{ request('category_id') == $category->id ? 'selected' : '' }}>
                                        {{ $category->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="mb-3">
                            <label class="form-label">Usuário</label>
                            <select name="user_id" class="form-select">
                                <option value="">Todos</option>
                                @foreach($users as $user)
                                    <option value="{{ $user->id }}" {{ request('user_id') == $user->id ? 'selected' : '' }}>
                                        {{ $user->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="mb-3">
                            <label class="form-label">Destaque</label>
                            <select name="is_featured" class="form-select">
                                <option value="">Todos</option>
                                <option value="1" {{ request('is_featured') == '1' ? 'selected' : '' }}>Sim</option>
                                <option value="0" {{ request('is_featured') == '0' ? 'selected' : '' }}>Não</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="mb-3">
                            <label class="form-label">Município</label>
                            <select name="municipality_id" class="form-select">
                                <option value="">Todos</option>
                                @foreach($municipalities as $municipality)
                                    <option value="{{ $municipality->id }}" {{ request('municipality_id') == $municipality->id ? 'selected' : '' }}>
                                        {{ $municipality->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="mb-3">
                            <label class="form-label">&nbsp;</label>
                            <button type="submit" class="btn btn-primary w-100">
                                <i class="bi bi-search"></i> Filtrar
                            </button>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-2">
                        <div class="mb-3">
                            <label class="form-label">Status</label>
                            <select name="status" class="form-select">
                                <option value="">Todos</option>
                                <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>Rascunho</option>
                                <option value="scheduled" {{ request('status') == 'scheduled' ? 'selected' : '' }}>Agendado</option>
                                <option value="published" {{ request('status') == 'published' ? 'selected' : '' }}>Publicado</option>
                                <option value="pending_review" {{ request('status') == 'pending_review' ? 'selected' : '' }}>Pendente Revisão</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="mb-3">
                            <label class="form-label">Data De</label>
                            <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="mb-3">
                            <label class="form-label">Data Até</label>
                            <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="mb-3">
                            <label class="form-label">Blog</label>
                            <select name="blog_id" class="form-select">
                                <option value="">Todos</option>
                                <!-- Adicionar blogs se existir -->
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="mb-3">
                            <label class="form-label">Coluna</label>
                            <input type="text" name="column" class="form-control" value="{{ request('column') }}" placeholder="Nome da coluna">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="mb-3">
                            <label class="form-label">&nbsp;</label>
                            <a href="{{ route('admin.news.index') }}" class="btn btn-secondary w-100">
                                <i class="bi bi-x-circle"></i> Limpar
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Tabela de Notícias -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Notícias ({{ $news->total() }})</h5>
            <div class="d-flex gap-2">
                <select class="form-select form-select-sm" style="width: auto;" id="bulkAction">
                    <option value="">Ações em massa</option>
                    <option value="publish">Publicar Selecionadas</option>
                    <option value="draft">Mover para Rascunho</option>
                    <option value="delete">Excluir</option>
                    <option value="trash">Mover para Lixeira</option>
                </select>
                <button type="button" class="btn btn-sm btn-primary" id="applyBulkAction" disabled>
                    Aplicar
                </button>
            </div>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th width="30">
                                <input type="checkbox" id="selectAll">
                            </th>
                            <th width="60">ID</th>
                            <th>Título</th>
                            <th width="150">Categoria</th>
                            <th width="120">Autor</th>
                            <th width="80" class="text-center">Acessos</th>
                            <th width="100">Status</th>
                            <th width="150">Data de Publicação</th>
                            <th width="150" class="text-center">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($news as $item)
                        <tr>
                            <td>
                                <input type="checkbox" class="news-checkbox" value="{{ $item->id }}">
                            </td>
                            <td>{{ $item->id }}</td>
                            <td>
                                <div class="d-flex align-items-center gap-2">
                                    @if($item->cover_image)
                                        <img src="{{ Storage::url($item->cover_image) }}" 
                                             alt="{{ $item->title }}" 
                                             class="img-thumbnail" 
                                             style="width: 50px; height: 50px; object-fit: cover;">
                                    @endif
                                    <div>
                                        <strong>{{ Str::limit($item->title, 60) }}</strong>
                                        @if($item->is_featured)
                                            <span class="badge badge-warning ms-1">Destaque</span>
                                        @endif
                                        @if($item->is_urgent)
                                            <span class="badge badge-danger ms-1">Urgente</span>
                                        @endif
                                        @if($item->is_headline)
                                            <span class="badge badge-info ms-1">Manchete</span>
                                        @endif
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="badge" style="background: {{ $item->category->color ?? '#3b82f6' }}; color: white;">
                                    {{ $item->category->name ?? '-' }}
                                </span>
                            </td>
                            <td>
                                <small>{{ $item->user->name ?? 'Sistema' }}</small>
                            </td>
                            <td class="text-center">
                                <span class="badge badge-info">{{ number_format($item->views ?? 0) }}</span>
                            </td>
                            <td>
                                @if($item->status === 'published')
                                    <span class="badge badge-success">Publicado</span>
                                @elseif($item->status === 'draft')
                                    <span class="badge badge-secondary">Rascunho</span>
                                @elseif($item->status === 'scheduled')
                                    <span class="badge badge-warning">Agendado</span>
                                @else
                                    <span class="badge badge-danger">Pendente</span>
                                @endif
                            </td>
                            <td>
                                <small>{{ $item->published_at ? $item->published_at->format('d/m/Y H:i') : '-' }}</small>
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm" role="group">
                                    <a href="{{ route('admin.news.edit', $item->id) }}" 
                                       class="btn btn-outline-primary" 
                                       title="Editar">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <button type="button" 
                                            class="btn btn-outline-info" 
                                            onclick="duplicateNews({{ $item->id }})"
                                            title="Duplicar">
                                        <i class="bi bi-files"></i>
                                    </button>
                                    <div class="btn-group btn-group-sm">
                                        <button type="button" 
                                                class="btn btn-outline-secondary dropdown-toggle" 
                                                data-bs-toggle="dropdown">
                                            <i class="bi bi-three-dots"></i>
                                        </button>
                                        <ul class="dropdown-menu">
                                            <li>
                                                <a class="dropdown-item" href="#" onclick="changeStatus({{ $item->id }}, 'published')">
                                                    <i class="bi bi-check-circle text-success"></i> Publicar
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="#" onclick="changeStatus({{ $item->id }}, 'draft')">
                                                    <i class="bi bi-file-text text-secondary"></i> Rascunho
                                                </a>
                                            </li>
                                            <li><hr class="dropdown-divider"></li>
                                            <li>
                                                <a class="dropdown-item text-danger" href="#" onclick="deleteNews({{ $item->id }})">
                                                    <i class="bi bi-trash"></i> Excluir
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item text-warning" href="#" onclick="moveToTrash({{ $item->id }})">
                                                    <i class="bi bi-trash3"></i> Mover para Lixeira
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="9" class="text-center py-4">
                                <p class="text-muted mb-0">Nenhuma notícia encontrada</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if($news->hasPages())
        <div class="card-footer">
            {{ $news->links() }}
        </div>
        @endif
    </div>
</div>

@endsection

@push('scripts')
<script>
    // Selecionar todos
    document.getElementById('selectAll').addEventListener('change', function() {
        const checkboxes = document.querySelectorAll('.news-checkbox');
        checkboxes.forEach(cb => cb.checked = this.checked);
        updateBulkActionButton();
    });

    // Atualizar botão de ação em massa
    document.querySelectorAll('.news-checkbox').forEach(cb => {
        cb.addEventListener('change', updateBulkActionButton);
    });

    function updateBulkActionButton() {
        const checked = document.querySelectorAll('.news-checkbox:checked');
        document.getElementById('applyBulkAction').disabled = checked.length === 0;
    }

    // Aplicar ação em massa
    document.getElementById('applyBulkAction').addEventListener('click', function() {
        const action = document.getElementById('bulkAction').value;
        const checked = Array.from(document.querySelectorAll('.news-checkbox:checked')).map(cb => cb.value);
        
        if (!action || checked.length === 0) return;

        if (confirm(`Deseja realmente ${action} ${checked.length} notícia(s)?`)) {
            fetch('{{ route('admin.news.index') }}/bulk-action', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                },
                body: JSON.stringify({ action, ids: checked })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('Erro ao executar ação');
                }
            });
        }
    });

    // Duplicar notícia
    function duplicateNews(id) {
        if (confirm('Deseja duplicar esta notícia?')) {
            fetch(`{{ route('admin.news.index') }}/${id}/duplicate`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                }
            });
        }
    }

    // Alterar status
    function changeStatus(id, status) {
        fetch(`{{ route('admin.news.index') }}/${id}/status`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({ status })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            }
        });
    }

    // Excluir notícia
    function deleteNews(id) {
        if (confirm('Deseja realmente excluir esta notícia permanentemente?')) {
            fetch(`{{ route('admin.news.index') }}/${id}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                }
            });
        }
    }

    // Mover para lixeira
    function moveToTrash(id) {
        if (confirm('Deseja mover esta notícia para a lixeira?')) {
            fetch(`{{ route('admin.news.index') }}/${id}/trash`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                }
            });
        }
    }
</script>
@endpush

