@extends('admin.layouts.app')

@section('title', 'Configurar Plugin: ' . $plugin->plugin_name)

@section('content')
<div class="plugin-configure-container">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Configurar Plugin: {{ $plugin->plugin_name }}</h2>
        <a href="{{ route('admin.plugins.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Voltar
        </a>
    </div>

    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Configurações</h5>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.plugins.update-config', $plugin->id) }}" method="POST">
                @csrf
                @method('PUT')

                @if($plugin->plugin_slug === 'socialpost')
                    <!-- Configurações SocialPost -->
                    <div class="mb-3">
                        <label class="form-label">Meta Graph API Token</label>
                        <input type="text" name="meta_token" class="form-control" 
                               value="{{ $plugin->config['meta_token'] ?? '' }}" 
                               placeholder="Token da API do Facebook/Instagram">
                        <small class="text-muted">Token obtido do Facebook Business</small>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Instagram Business Account ID</label>
                        <input type="text" name="instagram_account_id" class="form-control" 
                               value="{{ $plugin->config['instagram_account_id'] ?? '' }}">
                    </div>

                @elseif($plugin->plugin_slug === 'vocalize')
                    <!-- Configurações Vocalize -->
                    <div class="mb-3">
                        <label class="form-label">Provedor TTS</label>
                        <select name="tts_provider" class="form-select">
                            <option value="aws_polly" {{ ($plugin->config['tts_provider'] ?? 'aws_polly') == 'aws_polly' ? 'selected' : '' }}>AWS Polly</option>
                            <option value="elevenlabs" {{ ($plugin->config['tts_provider'] ?? '') == 'elevenlabs' ? 'selected' : '' }}>ElevenLabs</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">API Key</label>
                        <input type="text" name="api_key" class="form-control" 
                               value="{{ $plugin->config['api_key'] ?? '' }}">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Voz Padrão</label>
                        <select name="default_voice" class="form-select">
                            <option value="pt-BR-VitoriaNeural">Vitória (Feminina)</option>
                            <option value="pt-BR-FranciscaNeural">Francisca (Feminina)</option>
                            <option value="pt-BR-AntonioNeural">Antônio (Masculina)</option>
                        </select>
                    </div>

                @elseif($plugin->plugin_slug === 'autopost')
                    <!-- Configurações AutoPost -->
                    <div class="mb-3">
                        <label class="form-label">Frequência de Importação</label>
                        <select name="frequency" class="form-select">
                            <option value="10" {{ ($plugin->config['frequency'] ?? '30') == '10' ? 'selected' : '' }}>A cada 10 minutos</option>
                            <option value="20" {{ ($plugin->config['frequency'] ?? '30') == '20' ? 'selected' : '' }}>A cada 20 minutos</option>
                            <option value="30" {{ ($plugin->config['frequency'] ?? '30') == '30' ? 'selected' : '' }}>A cada 30 minutos</option>
                            <option value="60" {{ ($plugin->config['frequency'] ?? '30') == '60' ? 'selected' : '' }}>A cada 1 hora</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Publicar Automaticamente</label>
                        <select name="auto_publish" class="form-select">
                            <option value="draft" {{ ($plugin->config['auto_publish'] ?? 'draft') == 'draft' ? 'selected' : '' }}>Apenas Rascunho</option>
                            <option value="published" {{ ($plugin->config['auto_publish'] ?? 'draft') == 'published' ? 'selected' : '' }}>Publicar Automaticamente</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Quantidade de Notícias por Importação</label>
                        <input type="number" name="max_import" class="form-control" 
                               value="{{ $plugin->config['max_import'] ?? 5 }}" min="1" max="10">
                    </div>
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="send_notifications" value="1" 
                                   {{ ($plugin->config['send_notifications'] ?? false) ? 'checked' : '' }}>
                            <label class="form-check-label">Enviar Notificações (Push/WhatsApp)</label>
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="publish_social" value="1" 
                                   {{ ($plugin->config['publish_social'] ?? false) ? 'checked' : '' }}>
                            <label class="form-check-label">Publicar no Instagram/Facebook</label>
                        </div>
                    </div>

                @elseif($plugin->plugin_slug === 'push-notification')
                    <!-- Configurações Push Notification -->
                    <div class="mb-3">
                        <label class="form-label">Provedor</label>
                        <select name="provider" class="form-select">
                            <option value="onesignal" {{ ($plugin->config['provider'] ?? 'onesignal') == 'onesignal' ? 'selected' : '' }}>OneSignal</option>
                            <option value="push_protocol" {{ ($plugin->config['provider'] ?? '') == 'push_protocol' ? 'selected' : '' }}>Push Protocol</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">App ID</label>
                        <input type="text" name="app_id" class="form-control" 
                               value="{{ $plugin->config['app_id'] ?? '' }}">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">API Key</label>
                        <input type="text" name="api_key" class="form-control" 
                               value="{{ $plugin->config['api_key'] ?? '' }}">
                    </div>

                @else
                    <!-- Configurações Genéricas -->
                    <div class="alert alert-info">
                        <i class="bi bi-info-circle"></i> Este plugin não possui configurações específicas.
                    </div>
                @endif

                <div class="mt-4">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-save"></i> Salvar Configurações
                    </button>
                    <a href="{{ route('admin.plugins.index') }}" class="btn btn-secondary">Cancelar</a>
                </div>
            </form>
        </div>
    </div>

    @if(isset($plugin->config['documentation_url']))
    <div class="card mt-3">
        <div class="card-body">
            <h5>Documentação</h5>
            <a href="{{ $plugin->config['documentation_url'] }}" target="_blank" class="btn btn-outline-primary">
                <i class="bi bi-book"></i> Ver Documentação
            </a>
        </div>
    </div>
    @endif
</div>

@endsection

