<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Erro de Licença - Portal de Notícias</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .error-container {
            background: white;
            border-radius: 12px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            max-width: 700px;
            width: 100%;
            padding: 40px;
            text-align: center;
        }
        
        .error-icon {
            font-size: 64px;
            color: #ef4444;
            margin-bottom: 20px;
        }
        
        h1 {
            color: #1e293b;
            font-size: 28px;
            margin-bottom: 15px;
        }
        
        .error-message {
            color: #64748b;
            font-size: 16px;
            line-height: 1.6;
            margin-bottom: 30px;
            background: #f8fafc;
            padding: 15px;
            border-radius: 8px;
            text-align: left;
        }
        
        .error-details {
            background: #f8fafc;
            border-left: 4px solid #ef4444;
            padding: 15px;
            margin-bottom: 30px;
            text-align: left;
            border-radius: 4px;
        }
        
        .error-details strong {
            color: #1e293b;
            display: block;
            margin-bottom: 8px;
        }
        
        .error-details p {
            color: #64748b;
            font-size: 14px;
            margin: 5px 0;
        }
        
        .debug-info {
            background: #fef3c7;
            border: 1px solid #f59e0b;
            padding: 15px;
            margin-top: 20px;
            border-radius: 8px;
            text-align: left;
            font-size: 12px;
            font-family: monospace;
        }
        
        .debug-info strong {
            color: #92400e;
            display: block;
            margin-bottom: 8px;
        }
        
        .actions {
            display: flex;
            gap: 15px;
            justify-content: center;
            flex-wrap: wrap;
        }
        
        .btn {
            padding: 12px 24px;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s;
            display: inline-block;
        }
        
        .btn-primary {
            background: #3b82f6;
            color: white;
        }
        
        .btn-primary:hover {
            background: #2563eb;
        }
        
        .btn-secondary {
            background: #e5e7eb;
            color: #374151;
        }
        
        .btn-secondary:hover {
            background: #d1d5db;
        }
        
        .help-text {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #e5e7eb;
            font-size: 14px;
            color: #64748b;
            text-align: left;
        }
        
        .help-text code {
            background: #f3f4f6;
            padding: 2px 6px;
            border-radius: 4px;
            font-family: monospace;
            font-size: 12px;
        }
        
        .help-text a {
            color: #3b82f6;
            text-decoration: none;
        }
        
        .help-text a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="error-container">
        <div class="error-icon">⚠️</div>
        <h1>Erro ao Validar Licença</h1>
        <div class="error-message">
            {{ $message ?? 'Não foi possível validar a licença do sistema.' }}
        </div>
        
        @if(isset($debug) && $debug)
        <div class="debug-info">
            <strong>Informações de Debug:</strong>
            <pre>{{ json_encode($debug, JSON_PRETTY_PRINT) }}</pre>
        </div>
        @endif
        
        <div class="error-details">
            <strong>Possíveis causas:</strong>
            <p>• URL do Master Panel incorreta ou inacessível</p>
            <p>• Problema de conexão com a internet</p>
            <p>• Chave de licença não configurada ou inválida</p>
            <p>• Licença expirada ou revogada</p>
            <p>• Master Panel offline ou indisponível</p>
        </div>
        
        <div class="actions">
            <a href="{{ route('admin.settings.index') ?? '#' }}" class="btn btn-primary">
                Verificar Configurações
            </a>
            <a href="javascript:location.reload()" class="btn btn-secondary">
                Tentar Novamente
            </a>
        </div>
        
        <div class="help-text">
            <p><strong>Como resolver:</strong></p>
            <p>1. Verifique o arquivo <code>.env</code> e confirme:</p>
            <ul style="margin-left: 20px; margin-top: 10px;">
                <li><code>MASTER_PANEL_URL=https://master.canal33.com.br</code></li>
                <li><code>MASTER_PANEL_LICENSE_KEY=sua_chave_aqui</code></li>
            </ul>
            <p style="margin-top: 15px;">2. Teste se a URL está acessível:</p>
            <p style="margin-left: 20px;"><code>curl https://master.canal33.com.br/api/v1/validate-license?license_key=SUA_CHAVE</code></p>
            <p style="margin-top: 15px;">3. Limpe o cache após configurar:</p>
            <p style="margin-left: 20px;"><code>php artisan config:clear && php artisan cache:clear</code></p>
            <p style="margin-top: 15px;">4. Para desenvolvimento, você pode desabilitar temporariamente:</p>
            <p style="margin-left: 20px;"><code>MASTER_PANEL_DISABLE_CHECK=true</code></p>
            <p style="margin-top: 15px; color: #ef4444;"><strong>⚠️ NUNCA deixe DISABLE_CHECK=true em produção!</strong></p>
        </div>
    </div>
</body>
</html>
