@extends('frontend.v1.layouts.app')

@section('title', $category->name . ' - Portal de Notícias')

@section('content')
<div class="category-page">
    <div class="container">
        <div class="category-header">
            <h1 class="category-title" style="color: {{ $category->color ?? '#3b82f6' }};">
                {{ $category->name }}
            </h1>
            @if($category->description)
            <p class="category-description">{{ $category->description }}</p>
            @endif
        </div>

        <div class="category-layout">
            <div class="category-content">
                <div class="news-grid">
                    @forelse($news as $item)
                    <article class="news-card">
                        <a href="{{ route('news.show', $item->slug) }}">
                            <div class="news-card-image">
                                <img src="{{ Storage::url($item->cover_image ?? 'default.jpg') }}" alt="{{ $item->title }}">
                                <span class="news-card-category" style="background: {{ $item->category->color ?? '#3b82f6' }};">
                                    {{ $item->category->name }}
                                </span>
                            </div>
                            <div class="news-card-content">
                                <h3>{{ Str::limit($item->title, 80) }}</h3>
                                <p>{{ Str::limit($item->excerpt, 120) }}</p>
                                <div class="news-card-meta">
                                    <span>{{ $item->published_at->format('d/m/Y') }}</span>
                                    <span><i class="bi bi-eye"></i> {{ number_format($item->views) }}</span>
                                </div>
                            </div>
                        </a>
                    </article>
                    @empty
                    <div class="no-news">
                        <p>Nenhuma notícia encontrada nesta categoria.</p>
                    </div>
                    @endforelse
                </div>

                @if($news->hasPages())
                <div class="pagination-wrapper">
                    {{ $news->links() }}
                </div>
                @endif
            </div>

            <!-- Sidebar -->
            <aside class="category-sidebar">
                @if(isset($sidebarAds['vertical_300x600']) && $sidebarAds['vertical_300x600'])
                <div class="sidebar-ad">
                    @if($sidebarAds['vertical_300x600']->format === 'image' && $sidebarAds['vertical_300x600']->image)
                        <a href="{{ $sidebarAds['vertical_300x600']->link ?? '#' }}" target="_blank">
                            <img src="{{ Storage::url($sidebarAds['vertical_300x600']->image) }}" alt="Anúncio">
                        </a>
                    @else
                        {!! $sidebarAds['vertical_300x600']->content !!}
                    @endif
                </div>
                @endif
            </aside>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .category-page { padding: 30px 0; }
    .category-header { margin-bottom: 40px; text-align: center; }
    .category-title { font-size: 42px; font-weight: 700; margin-bottom: 15px; }
    .category-description { font-size: 18px; color: #64748b; }
    .category-layout { display: grid; grid-template-columns: 2fr 1fr; gap: 40px; }
    .news-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 25px; }
    .news-card { background: white; border-radius: 12px; overflow: hidden; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
    .news-card-image { position: relative; height: 200px; overflow: hidden; }
    .news-card-image img { width: 100%; height: 100%; object-fit: cover; }
    .news-card-category { position: absolute; top: 10px; left: 10px; padding: 4px 10px; border-radius: 4px; color: white; font-size: 11px; }
    .news-card-content { padding: 20px; }
    .news-card-content h3 { font-size: 18px; font-weight: 700; margin-bottom: 10px; color: #1e293b; }
    .news-card-content p { font-size: 14px; color: #64748b; margin-bottom: 12px; }
    .news-card-meta { display: flex; justify-content: space-between; font-size: 12px; color: #94a3b8; }
    @media (max-width: 768px) {
        .category-layout { grid-template-columns: 1fr; }
        .news-grid { grid-template-columns: 1fr; }
    }
</style>
@endpush

