@extends('frontend.v1.layouts.app')

@section('title', 'Home - Portal de Notícias')

@section('content')
<!-- Banner Principal (Hero) - Grid de 4 notícias no topo -->
<section class="hero-section">
    <div class="container">
        <div class="hero-grid-top">
            @if(isset($featuredNews) && $featuredNews->count() > 0)
            @foreach($featuredNews->take(4) as $news)
            <a href="{{ route('news.show', $news->slug) }}" class="hero-card-small">
                <div class="hero-card-image">
                    <img src="{{ Storage::url($news->cover_image ?? 'default.jpg') }}" alt="{{ $news->title }}">
                    <span class="hero-card-badge" style="background: {{ $news->category->color ?? '#3b82f6' }};">
                        {{ $news->category->name }}
                    </span>
                </div>
                <h3 class="hero-card-title">{{ Str::limit($news->title, 60) }}</h3>
            </a>
            @endforeach
            @else
            <p>Nenhuma notícia em destaque no momento.</p>
            @endif
        </div>
        
        <div class="hero-grid-main">
            @if($heroNews)
            <div class="hero-main">
                <a href="{{ route('news.show', $heroNews->slug) }}" class="hero-card">
                    <div class="hero-image">
                        <img src="{{ Storage::url($heroNews->cover_image ?? 'default.jpg') }}" alt="{{ $heroNews->title }}">
                        <div class="hero-overlay">
                            <span class="hero-category" style="background: {{ $heroNews->category->color ?? '#3b82f6' }};">
                                {{ $heroNews->category->name }}
                            </span>
                        </div>
                    </div>
                    <div class="hero-content">
                        <h1 class="hero-title">{{ $heroNews->title }}</h1>
                        <p class="hero-excerpt">{{ Str::limit($heroNews->excerpt, 150) }}</p>
                        <div class="hero-meta">
                            <span><i class="bi bi-person"></i> {{ $heroNews->user->name }}</span>
                            <span><i class="bi bi-calendar"></i> {{ $heroNews->published_at->format('d/m/Y H:i') }}</span>
                        </div>
                    </div>
                </a>
            </div>
            @endif

            <div class="hero-side">
                @if(isset($heroSideNews) && $heroSideNews->count() > 0)
                @foreach($heroSideNews as $sideNews)
                <a href="{{ route('news.show', $sideNews->slug) }}" class="hero-side-card">
                    <div class="hero-side-image">
                        <img src="{{ Storage::url($sideNews->cover_image ?? 'default.jpg') }}" alt="{{ $sideNews->title }}">
                    </div>
                    <div class="hero-side-content">
                        <span class="hero-side-category" style="color: {{ $sideNews->category->color ?? '#3b82f6' }};">
                            {{ $sideNews->category->name }}
                        </span>
                        <h3>{{ Str::limit($sideNews->title, 70) }}</h3>
                        <span class="hero-side-date">{{ $sideNews->published_at->format('d/m/Y') }}</span>
                    </div>
                </a>
                @endforeach
                @endif
            </div>
        </div>
    </div>
</section>

<!-- Bloco de Destaques -->
<section class="featured-section">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">Destaques</h2>
            <div class="section-line"></div>
        </div>
        <div class="featured-grid">
            @if(isset($featuredNews) && $featuredNews->count() > 0)
            @foreach($featuredNews as $news)
            <article class="featured-card">
                <a href="{{ route('news.show', $news->slug) }}">
                    <div class="featured-image">
                        <img src="{{ Storage::url($news->cover_image ?? 'default.jpg') }}" alt="{{ $news->title }}">
                        <span class="featured-category" style="background: {{ $news->category->color ?? '#3b82f6' }};">
                            {{ $news->category->name }}
                        </span>
                    </div>
                    <div class="featured-content">
                        <h3>{{ Str::limit($news->title, 80) }}</h3>
                        <p>{{ Str::limit($news->excerpt, 100) }}</p>
                        <div class="featured-meta">
                            <span>{{ $news->published_at->format('d/m/Y') }}</span>
                            <span><i class="bi bi-eye"></i> {{ number_format($news->views) }}</span>
                        </div>
                    </div>
                </a>
            </article>
            @endforeach
            @else
            <p>Nenhuma notícia em destaque no momento.</p>
            @endif
        </div>
    </div>
</section>

<!-- Trending / Em Alta -->
@if($trendingNews->count() > 0)
<section class="trending-section">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">Em Alta</h2>
            <div class="section-line"></div>
        </div>
        <div class="trending-list">
            @foreach($trendingNews as $index => $news)
            <article class="trending-item">
                <span class="trending-number">{{ $index + 1 }}</span>
                <div class="trending-content">
                    <a href="{{ route('news.show', $news->slug) }}">
                        <h4>{{ Str::limit($news->title, 80) }}</h4>
                        <span class="trending-meta">{{ $news->category->name }} • {{ $news->published_at->format('d/m/Y') }}</span>
                    </a>
                </div>
            </article>
            @endforeach
        </div>
    </div>
</section>
@endif

<!-- Blocos por Categoria -->
@if(isset($categoryBlocks) && count($categoryBlocks) > 0)
@foreach($categoryBlocks as $block)
@if($block['featured'] || $block['posts']->count() > 0)
<section class="category-section">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title" style="color: {{ $block['category']->color ?? '#3b82f6' }};">
                {{ $block['category']->name }}
            </h2>
            <div class="section-line" style="background: {{ $block['category']->color ?? '#3b82f6' }};"></div>
            <a href="{{ route('category.show.v1', $block['category']->slug) }}" class="section-more">Ver todos <i class="bi bi-arrow-right"></i></a>
        </div>
        
        <div class="category-content">
            @if($block['featured'])
            <div class="category-featured">
                <a href="{{ route('news.show', $block['featured']->slug) }}" class="category-featured-card">
                    <div class="category-featured-image">
                        <img src="{{ Storage::url($block['featured']->cover_image ?? 'default.jpg') }}" alt="{{ $block['featured']->title }}">
                    </div>
                    <div class="category-featured-content">
                        <h3>{{ $block['featured']->title }}</h3>
                        <p>{{ Str::limit($block['featured']->excerpt, 150) }}</p>
                        <div class="category-featured-meta">
                            <span>{{ $block['featured']->user->name }}</span>
                            <span>{{ $block['featured']->published_at->format('d/m/Y H:i') }}</span>
                        </div>
                    </div>
                </a>
            </div>
            @endif
            
            <div class="category-posts">
                @foreach($block['posts']->take(6) as $post)
                <article class="category-post-card">
                    <a href="{{ route('news.show', $post->slug) }}">
                        <div class="category-post-image">
                            <img src="{{ Storage::url($post->cover_image ?? 'default.jpg') }}" alt="{{ $post->title }}">
                        </div>
                        <div class="category-post-content">
                            <h4>{{ Str::limit($post->title, 70) }}</h4>
                            <span class="category-post-date">{{ $post->published_at->format('d/m/Y') }}</span>
                        </div>
                    </a>
                </article>
                @endforeach
            </div>
        </div>
    </div>
</section>
@endif
@endforeach
@endif

<!-- Bloco de Vídeos -->
@if($featuredVideo || $recentVideos->count() > 0)
<section class="videos-section">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">Vídeos</h2>
            <div class="section-line"></div>
            <a href="#" class="section-more">Ver todos <i class="bi bi-arrow-right"></i></a>
        </div>
        
        <div class="videos-content">
            @if($featuredVideo)
            <div class="video-featured">
                <div class="video-player">
                    @if($featuredVideo->provider === 'youtube')
                        <iframe src="https://www.youtube.com/embed/{{ $featuredVideo->video_id }}" frameborder="0" allowfullscreen></iframe>
                    @elseif($featuredVideo->provider === 'vimeo')
                        <iframe src="https://player.vimeo.com/video/{{ $featuredVideo->video_id }}" frameborder="0" allowfullscreen></iframe>
                    @endif
                </div>
                <h3>{{ $featuredVideo->title }}</h3>
            </div>
            @endif
            
            <div class="videos-grid">
                @if(isset($recentVideos) && $recentVideos->count() > 0)
                @foreach($recentVideos->take(6) as $video)
                <article class="video-card">
                    <a href="#">
                        <div class="video-thumbnail">
                            <img src="{{ Storage::url($video->thumbnail ?? 'default.jpg') }}" alt="{{ $video->title }}">
                            <div class="video-play-icon"><i class="bi bi-play-circle-fill"></i></div>
                        </div>
                        <h4>{{ Str::limit($video->title, 60) }}</h4>
                    </a>
                </article>
                @endforeach
            </div>
        </div>
    </div>
</section>
@endif

<!-- Bloco de Colunistas -->
@if(isset($columnists) && $columnists->count() > 0)
<section class="columnists-section">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">Colunistas</h2>
            <div class="section-line"></div>
        </div>
        <div class="columnists-grid">
            @foreach($columnists as $columnist)
            <article class="columnist-card">
                <div class="columnist-avatar">
                    <img src="{{ Storage::url($columnist->avatar ?? 'default-avatar.jpg') }}" alt="{{ $columnist->name }}">
                </div>
                <div class="columnist-content">
                    <h4>{{ $columnist->name }}</h4>
                    @if($columnist->latest_news)
                    <a href="{{ route('news.show', $columnist->latest_news->slug) }}">
                        <p>{{ Str::limit($columnist->latest_news->title, 80) }}</p>
                        <span class="columnist-date">{{ $columnist->latest_news->published_at->format('d/m/Y') }}</span>
                    </a>
                    @endif
                </div>
            </article>
            @endforeach
        </div>
    </div>
</section>
@endif

<!-- Bloco de Podcast (Opcional) -->
@if(isset($featuredPodcast) && $featuredPodcast || (isset($recentPodcasts) && $recentPodcasts->count() > 0))
<section class="podcasts-section">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">Podcasts</h2>
            <div class="section-line"></div>
            <a href="#" class="section-more">Ver todos <i class="bi bi-arrow-right"></i></a>
        </div>
        
        <div class="podcasts-content">
            @if($featuredPodcast)
            <div class="podcast-featured">
                <div class="podcast-featured-card">
                    <div class="podcast-featured-image">
                        <img src="{{ $featuredPodcast->thumbnail_url }}" alt="{{ $featuredPodcast->title }}">
                        <div class="podcast-play-overlay">
                            <button class="podcast-play-btn" data-audio="{{ $featuredPodcast->audio_url }}">
                                <i class="bi bi-play-circle-fill"></i>
                            </button>
                        </div>
                    </div>
                    <div class="podcast-featured-info">
                        <span class="podcast-badge">Podcast em Destaque</span>
                        <h3>{{ $featuredPodcast->title }}</h3>
                        <p>{{ Str::limit($featuredPodcast->description, 150) }}</p>
                        <div class="podcast-meta">
                            @if($featuredPodcast->author)
                            <span><i class="bi bi-person"></i> {{ $featuredPodcast->author }}</span>
                            @endif
                            <span><i class="bi bi-clock"></i> {{ $featuredPodcast->formatted_duration }}</span>
                            <span><i class="bi bi-calendar"></i> {{ $featuredPodcast->published_at->format('d/m/Y') }}</span>
                        </div>
                        <audio id="podcast-audio-featured" controls class="podcast-audio-player" style="width: 100%; margin-top: 15px; display: none;">
                            <source src="{{ $featuredPodcast->audio_url }}" type="audio/mpeg">
                            Seu navegador não suporta áudio.
                        </audio>
                    </div>
                </div>
            </div>
            @endif
            
            <div class="podcasts-grid">
                @if(isset($recentPodcasts) && $recentPodcasts->count() > 0)
                @foreach($recentPodcasts->take(6) as $podcast)
                <article class="podcast-card">
                    <div class="podcast-image">
                        <img src="{{ $podcast->thumbnail_url }}" alt="{{ $podcast->title }}">
                        <button class="podcast-play-btn-small" data-audio="{{ $podcast->audio_url }}" data-id="{{ $podcast->id }}">
                            <i class="bi bi-play-circle-fill"></i>
                        </button>
                    </div>
                    <div class="podcast-content">
                        <h4>{{ Str::limit($podcast->title, 60) }}</h4>
                        <div class="podcast-meta-small">
                            <span><i class="bi bi-clock"></i> {{ $podcast->formatted_duration }}</span>
                            <span><i class="bi bi-calendar"></i> {{ $podcast->published_at->format('d/m/Y') }}</span>
                        </div>
                    </div>
                    <audio id="podcast-audio-{{ $podcast->id }}" controls class="podcast-audio-player" style="width: 100%; margin-top: 10px; display: none;">
                        <source src="{{ $podcast->audio_url }}" type="audio/mpeg">
                        Seu navegador não suporta áudio.
                    </audio>
                </article>
                @endforeach
                @endif
            </div>
        </div>
    </div>
</section>
@endif
@endsection

@push('styles')
<style>
    .hero-section { margin: 30px 0; }
    .hero-grid-top { display: grid; grid-template-columns: repeat(4, 1fr); gap: 15px; margin-bottom: 30px; }
    .hero-card-small { background: white; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 4px rgba(0,0,0,0.1); transition: transform 0.3s; }
    .hero-card-small:hover { transform: translateY(-5px); }
    .hero-card-image { position: relative; height: 180px; overflow: hidden; }
    .hero-card-image img { width: 100%; height: 100%; object-fit: cover; }
    .hero-card-badge { position: absolute; top: 10px; left: 10px; padding: 4px 10px; border-radius: 4px; color: white; font-size: 11px; font-weight: 600; }
    .hero-card-title { font-size: 14px; font-weight: 600; padding: 12px; margin: 0; color: #1e293b; line-height: 1.4; }
    .hero-grid { display: grid; grid-template-columns: 2fr 1fr; gap: 30px; }
    .hero-main .hero-card { display: block; border-radius: 12px; overflow: hidden; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
    .hero-image { position: relative; height: 400px; overflow: hidden; }
    .hero-image img { width: 100%; height: 100%; object-fit: cover; }
    .hero-overlay { position: absolute; top: 20px; left: 20px; }
    .hero-category { padding: 6px 12px; border-radius: 4px; color: white; font-size: 12px; font-weight: 600; }
    .hero-content { padding: 25px; background: white; }
    .hero-title { font-size: 28px; font-weight: 700; margin-bottom: 15px; color: #1e293b; }
    .hero-excerpt { color: #64748b; margin-bottom: 15px; line-height: 1.6; }
    .hero-meta { display: flex; gap: 20px; font-size: 14px; color: #94a3b8; }
    .hero-side { display: flex; flex-direction: column; gap: 20px; }
    .hero-side-card { display: flex; gap: 15px; padding: 15px; background: white; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
    .hero-side-image { width: 120px; height: 100px; border-radius: 6px; overflow: hidden; flex-shrink: 0; }
    .hero-side-image img { width: 100%; height: 100%; object-fit: cover; }
    .hero-side-content h3 { font-size: 16px; font-weight: 600; margin: 8px 0; color: #1e293b; }
    .hero-side-category { font-size: 12px; font-weight: 600; }
    .hero-side-date { font-size: 12px; color: #94a3b8; }
    
    .featured-section, .trending-section, .category-section, .videos-section,     .columnists-section, .podcasts-section { margin: 60px 0; }
    .section-header { display: flex; align-items: center; gap: 15px; margin-bottom: 30px; }
    .section-title { font-size: 32px; font-weight: 700; color: #1e293b; }
    .section-line { flex: 1; height: 3px; background: #3b82f6; }
    .section-more { color: #3b82f6; font-weight: 600; text-decoration: none; }
    
    /* Podcast Section */
    .podcasts-content { display: grid; grid-template-columns: 1fr 2fr; gap: 30px; }
    .podcast-featured-card { background: white; border-radius: 12px; overflow: hidden; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
    .podcast-featured-image { position: relative; height: 300px; overflow: hidden; }
    .podcast-featured-image img { width: 100%; height: 100%; object-fit: cover; }
    .podcast-play-overlay { position: absolute; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.3); display: flex; align-items: center; justify-content: center; }
    .podcast-play-btn { background: rgba(255,255,255,0.9); border: none; border-radius: 50%; width: 80px; height: 80px; display: flex; align-items: center; justify-content: center; cursor: pointer; transition: transform 0.3s; font-size: 48px; color: #3b82f6; }
    .podcast-play-btn:hover { transform: scale(1.1); background: white; }
    .podcast-featured-info { padding: 25px; }
    .podcast-badge { display: inline-block; background: #3b82f6; color: white; padding: 4px 12px; border-radius: 4px; font-size: 12px; font-weight: 600; margin-bottom: 10px; }
    .podcast-featured-info h3 { font-size: 24px; font-weight: 700; margin-bottom: 12px; color: #1e293b; }
    .podcast-featured-info p { color: #64748b; margin-bottom: 15px; line-height: 1.6; }
    .podcast-meta { display: flex; gap: 20px; font-size: 14px; color: #94a3b8; }
    .podcast-meta i { margin-right: 5px; }
    
    .podcasts-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 20px; }
    .podcast-card { background: white; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 4px rgba(0,0,0,0.1); transition: transform 0.3s; }
    .podcast-card:hover { transform: translateY(-5px); }
    .podcast-image { position: relative; height: 180px; overflow: hidden; }
    .podcast-image img { width: 100%; height: 100%; object-fit: cover; }
    .podcast-play-btn-small { position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); background: rgba(255,255,255,0.9); border: none; border-radius: 50%; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center; cursor: pointer; transition: transform 0.3s; font-size: 28px; color: #3b82f6; }
    .podcast-play-btn-small:hover { transform: translate(-50%, -50%) scale(1.1); background: white; }
    .podcast-content { padding: 15px; }
    .podcast-content h4 { font-size: 16px; font-weight: 600; margin-bottom: 8px; color: #1e293b; }
    .podcast-meta-small { display: flex; gap: 15px; font-size: 12px; color: #94a3b8; }
    .podcast-meta-small i { margin-right: 3px; }
    
    .featured-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 20px; }
    .featured-card { background: white; border-radius: 12px; overflow: hidden; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
    .featured-image { position: relative; height: 200px; overflow: hidden; }
    .featured-image img { width: 100%; height: 100%; object-fit: cover; }
    .featured-category { position: absolute; top: 10px; left: 10px; padding: 4px 10px; border-radius: 4px; color: white; font-size: 11px; }
    .featured-content { padding: 15px; }
    .featured-content h3 { font-size: 16px; font-weight: 600; margin-bottom: 8px; color: #1e293b; }
    .featured-content p { font-size: 14px; color: #64748b; margin-bottom: 10px; }
    .featured-meta { display: flex; justify-content: space-between; font-size: 12px; color: #94a3b8; }
    
    .trending-list { display: flex; flex-direction: column; gap: 15px; }
    .trending-item { display: flex; gap: 15px; align-items: center; padding: 15px; background: white; border-radius: 8px; }
    .trending-number { font-size: 24px; font-weight: 700; color: #3b82f6; min-width: 40px; }
    .trending-content h4 { font-size: 16px; font-weight: 600; margin-bottom: 5px; color: #1e293b; }
    .trending-meta { font-size: 12px; color: #94a3b8; }
    
    .category-content { display: grid; grid-template-columns: 1fr 2fr; gap: 30px; }
    .category-featured-card { display: block; background: white; border-radius: 12px; overflow: hidden; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
    .category-featured-image { height: 300px; overflow: hidden; }
    .category-featured-image img { width: 100%; height: 100%; object-fit: cover; }
    .category-featured-content { padding: 20px; }
    .category-featured-content h3 { font-size: 22px; font-weight: 700; margin-bottom: 10px; color: #1e293b; }
    .category-posts { display: grid; grid-template-columns: repeat(3, 1fr); gap: 20px; }
    .category-post-card { background: white; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
    .category-post-image { height: 150px; overflow: hidden; }
    .category-post-image img { width: 100%; height: 100%; object-fit: cover; }
    .category-post-content { padding: 12px; }
    .category-post-content h4 { font-size: 14px; font-weight: 600; margin-bottom: 5px; color: #1e293b; }
    .category-post-date { font-size: 12px; color: #94a3b8; }
    
    .videos-content { display: grid; grid-template-columns: 1fr 2fr; gap: 30px; }
    .video-player { position: relative; padding-bottom: 56.25%; height: 0; overflow: hidden; border-radius: 12px; }
    .video-player iframe { position: absolute; top: 0; left: 0; width: 100%; height: 100%; }
    .videos-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 20px; }
    .video-card { background: white; border-radius: 8px; overflow: hidden; }
    .video-thumbnail { position: relative; height: 150px; overflow: hidden; }
    .video-thumbnail img { width: 100%; height: 100%; object-fit: cover; }
    .video-play-icon { position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); font-size: 48px; color: white; opacity: 0.9; }
    .video-card h4 { padding: 12px; font-size: 14px; font-weight: 600; color: #1e293b; }
    
    .columnists-grid { display: grid; grid-template-columns: repeat(6, 1fr); gap: 20px; }
    .columnist-card { background: white; padding: 20px; border-radius: 12px; text-align: center; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
    .columnist-avatar { width: 80px; height: 80px; border-radius: 50%; overflow: hidden; margin: 0 auto 15px; }
    .columnist-avatar img { width: 100%; height: 100%; object-fit: cover; }
    .columnist-content h4 { font-size: 16px; font-weight: 600; margin-bottom: 10px; color: #1e293b; }
    .columnist-content p { font-size: 13px; color: #64748b; margin-bottom: 5px; }
    .columnist-date { font-size: 12px; color: #94a3b8; }
    
    @media (max-width: 768px) {
        .hero-grid-top { grid-template-columns: repeat(2, 1fr); }
        .hero-grid { grid-template-columns: 1fr; }
        .featured-grid { grid-template-columns: repeat(2, 1fr); }
        .category-content { grid-template-columns: 1fr; }
        .category-posts { grid-template-columns: 1fr; }
        .videos-content { grid-template-columns: 1fr; }
        .videos-grid { grid-template-columns: repeat(2, 1fr); }
        .columnists-grid { grid-template-columns: repeat(2, 1fr); }
        .podcasts-content { grid-template-columns: 1fr; }
        .podcasts-grid { grid-template-columns: repeat(2, 1fr); }
    }
</style>
@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Controle de reprodução de podcasts
    document.querySelectorAll('.podcast-play-btn, .podcast-play-btn-small').forEach(function(btn) {
        btn.addEventListener('click', function() {
            const audioUrl = this.getAttribute('data-audio');
            const podcastId = this.getAttribute('data-id');
            
            if (!podcastId) {
                // Se não tem data-id, é o podcast destacado
                podcastId = 'featured';
            }
            
            const audioPlayer = document.getElementById('podcast-audio-' + podcastId);
            
            // Pausar todos os outros players
            document.querySelectorAll('.podcast-audio-player').forEach(function(player) {
                if (player !== audioPlayer) {
                    player.pause();
                    player.style.display = 'none';
                }
            });
            
            // Mostrar e tocar o player selecionado
            if (audioPlayer) {
                audioPlayer.style.display = 'block';
                if (audioPlayer.paused) {
                    audioPlayer.play();
                } else {
                    audioPlayer.pause();
                }
            }
        });
    });
});
</script>
@endpush
@endpush
