@extends('frontend.v1.layouts.app')

@section('title', $news->title)
@section('description', $news->excerpt)
@section('og_title', $news->title)
@section('og_description', $news->excerpt)
@section('og_image', Storage::url($news->cover_image ?? 'default.jpg'))

@section('content')
<div class="news-page">
    <div class="container">
        <div class="news-layout">
            <!-- Conteúdo Principal -->
            <article class="news-main">
                <!-- Categoria e Breadcrumb -->
                <nav class="news-breadcrumb">
                    <a href="{{ route('home') }}">Home</a>
                    <span>/</span>
                    <a href="{{ route('category.show', $news->category->slug) }}">{{ $news->category->name }}</a>
                    <span>/</span>
                    <span>{{ Str::limit($news->title, 50) }}</span>
                </nav>

                <!-- Título -->
                <h1 class="news-title">{{ $news->title }}</h1>
                @if($news->subtitle)
                <h2 class="news-subtitle">{{ $news->subtitle }}</h2>
                @endif

                <!-- Meta Informações -->
                <div class="news-meta">
                    <div class="news-meta-left">
                        <span class="news-author">
                            <i class="bi bi-person"></i>
                            {{ $news->user->name }}
                        </span>
                        <span class="news-date">
                            <i class="bi bi-calendar"></i>
                            {{ $news->published_at->format('d/m/Y H:i') }}
                        </span>
                        <span class="news-category" style="background: {{ $news->category->color ?? '#3b82f6' }}; color: white; padding: 4px 12px; border-radius: 4px;">
                            {{ $news->category->name }}
                        </span>
                    </div>
                    <div class="news-meta-right">
                        <span class="news-views">
                            <i class="bi bi-eye"></i>
                            {{ number_format($news->views) }} visualizações
                        </span>
                    </div>
                </div>

                <!-- Botões de Compartilhamento -->
                <div class="news-share">
                    <span>Compartilhar:</span>
                    <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(url()->current()) }}" target="_blank" class="share-btn share-facebook">
                        <i class="bi bi-facebook"></i> Facebook
                    </a>
                    <a href="https://twitter.com/intent/tweet?url={{ urlencode(url()->current()) }}&text={{ urlencode($news->title) }}" target="_blank" class="share-btn share-twitter">
                        <i class="bi bi-twitter"></i> Twitter
                    </a>
                    <a href="https://api.whatsapp.com/send?text={{ urlencode($news->title . ' ' . url()->current()) }}" target="_blank" class="share-btn share-whatsapp">
                        <i class="bi bi-whatsapp"></i> WhatsApp
                    </a>
                    <a href="#" onclick="copyToClipboard('{{ url()->current() }}')" class="share-btn share-link">
                        <i class="bi bi-link-45deg"></i> Copiar Link
                    </a>
                </div>

                <!-- Foto Principal -->
                @if($news->cover_image)
                <div class="news-cover">
                    <img src="{{ Storage::url($news->cover_image) }}" alt="{{ $news->title }}">
                    @if($news->cover_credit)
                    <p class="news-credit">{{ $news->cover_credit }}</p>
                    @endif
                </div>
                @endif

                <!-- Corpo do Texto -->
                <div class="news-body">
                    {!! $news->body !!}
                </div>

                <!-- Tags -->
                @if($news->tags->count() > 0)
                <div class="news-tags">
                    <span>Tags:</span>
                    @foreach($news->tags as $tag)
                    <a href="#" class="tag-link">{{ $tag->name }}</a>
                    @endforeach
                </div>
                @endif

                <!-- Rodapé da Notícia -->
                <div class="news-footer">
                    <div class="news-author-box">
                        <div class="author-avatar">
                            <img src="{{ Storage::url($news->user->avatar ?? 'default-avatar.jpg') }}" alt="{{ $news->user->name }}">
                        </div>
                        <div class="author-info">
                            <h4>{{ $news->user->name }}</h4>
                            @if($news->user->bio)
                            <p>{{ $news->user->bio }}</p>
                            @endif
                            <div class="author-social">
                                @if($news->user->facebook)
                                <a href="{{ $news->user->facebook }}" target="_blank"><i class="bi bi-facebook"></i></a>
                                @endif
                                @if($news->user->twitter)
                                <a href="{{ $news->user->twitter }}" target="_blank"><i class="bi bi-twitter"></i></a>
                                @endif
                                @if($news->user->instagram)
                                <a href="{{ $news->user->instagram }}" target="_blank"><i class="bi bi-instagram"></i></a>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Leia Também -->
                @if($relatedNews->count() > 0)
                <section class="related-news">
                    <h3 class="related-title">Leia Também</h3>
                    <div class="related-grid">
                        @foreach($relatedNews->take(6) as $related)
                        <article class="related-card">
                            <a href="{{ route('news.show', $related->slug) }}">
                                <div class="related-image">
                                    <img src="{{ Storage::url($related->cover_image ?? 'default.jpg') }}" alt="{{ $related->title }}">
                                </div>
                                <div class="related-content">
                                    <h4>{{ Str::limit($related->title, 70) }}</h4>
                                    <span class="related-date">{{ $related->published_at->format('d/m/Y') }}</span>
                                </div>
                            </a>
                        </article>
                        @endforeach
                    </div>
                </section>
                @endif
            </article>

            <!-- Sidebar -->
            <aside class="news-sidebar">
                @include('frontend.v1.partials.widgets', [
                    'mostRead' => $mostRead,
                    'latestNews' => $latestNews,
                    'recentVideos' => []
                ])
                <!-- Anúncio 300x600 -->
                @if(isset($sidebarAds['vertical_300x600']) && $sidebarAds['vertical_300x600'])
                <div class="sidebar-ad">
                    @if($sidebarAds['vertical_300x600']->format === 'image' && $sidebarAds['vertical_300x600']->image)
                        <a href="{{ $sidebarAds['vertical_300x600']->link ?? '#' }}" target="_blank">
                            <img src="{{ Storage::url($sidebarAds['vertical_300x600']->image) }}" alt="Anúncio">
                        </a>
                    @elseif($sidebarAds['vertical_300x600']->format === 'html')
                        {!! $sidebarAds['vertical_300x600']->content !!}
                    @elseif($sidebarAds['vertical_300x600']->format === 'script')
                        {!! $sidebarAds['vertical_300x600']->content !!}
                    @endif
                </div>
                @endif

                <!-- Mais Lidas -->
                <div class="sidebar-widget">
                    <h3 class="widget-title">Mais Lidas</h3>
                    <ul class="widget-list">
                        @foreach($mostRead as $read)
                        <li>
                            <a href="{{ route('news.show', $read->slug) }}">
                                <span class="widget-number">{{ $loop->iteration }}</span>
                                <span class="widget-text">{{ Str::limit($read->title, 60) }}</span>
                            </a>
                        </li>
                        @endforeach
                    </ul>
                </div>

                <!-- Anúncio 300x250 -->
                @if(isset($sidebarAds['rectangle_300x250']) && $sidebarAds['rectangle_300x250'])
                <div class="sidebar-ad">
                    @if($sidebarAds['rectangle_300x250']->format === 'image' && $sidebarAds['rectangle_300x250']->image)
                        <a href="{{ $sidebarAds['rectangle_300x250']->link ?? '#' }}" target="_blank">
                            <img src="{{ Storage::url($sidebarAds['rectangle_300x250']->image) }}" alt="Anúncio">
                        </a>
                    @elseif($sidebarAds['rectangle_300x250']->format === 'html')
                        {!! $sidebarAds['rectangle_300x250']->content !!}
                    @elseif($sidebarAds['rectangle_300x250']->format === 'script')
                        {!! $sidebarAds['rectangle_300x250']->content !!}
                    @endif
                </div>
                @endif

                <!-- Mais Recentes -->
                <div class="sidebar-widget">
                    <h3 class="widget-title">Mais Recentes</h3>
                    <ul class="widget-list">
                        @foreach($latestNews as $latest)
                        <li>
                            <a href="{{ route('news.show', $latest->slug) }}">
                                <div class="widget-post-image">
                                    <img src="{{ Storage::url($latest->cover_image ?? 'default.jpg') }}" alt="{{ $latest->title }}">
                                </div>
                                <div class="widget-post-content">
                                    <span class="widget-post-title">{{ Str::limit($latest->title, 50) }}</span>
                                    <span class="widget-post-date">{{ $latest->published_at->format('d/m/Y') }}</span>
                                </div>
                            </a>
                        </li>
                        @endforeach
                    </ul>
                </div>
            </aside>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .news-page { padding: 30px 0; }
    .news-layout { display: grid; grid-template-columns: 2fr 1fr; gap: 40px; }
    .news-main { background: white; padding: 40px; border-radius: 12px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
    .news-breadcrumb { margin-bottom: 20px; font-size: 14px; color: #6b7280; }
    .news-breadcrumb a { color: #3b82f6; text-decoration: none; }
    .news-title { font-size: 36px; font-weight: 700; line-height: 1.2; margin-bottom: 15px; color: #1e293b; }
    .news-subtitle { font-size: 24px; font-weight: 400; color: #64748b; margin-bottom: 20px; }
    .news-meta { display: flex; justify-content: space-between; align-items: center; padding: 20px 0; border-top: 1px solid #e5e7eb; border-bottom: 1px solid #e5e7eb; margin-bottom: 20px; }
    .news-meta-left { display: flex; gap: 20px; align-items: center; }
    .news-meta span { font-size: 14px; color: #6b7280; }
    .news-share { display: flex; align-items: center; gap: 10px; margin-bottom: 30px; padding: 15px; background: #f9fafb; border-radius: 8px; }
    .share-btn { padding: 8px 16px; border-radius: 6px; text-decoration: none; font-size: 14px; font-weight: 600; color: white; }
    .share-facebook { background: #1877f2; }
    .share-twitter { background: #1da1f2; }
    .share-whatsapp { background: #25d366; }
    .share-link { background: #6b7280; }
    .news-cover { margin-bottom: 30px; }
    .news-cover img { width: 100%; border-radius: 12px; }
    .news-credit { font-size: 12px; color: #9ca3af; margin-top: 8px; text-align: center; }
    .news-body { font-size: 18px; line-height: 1.8; color: #374151; margin-bottom: 30px; }
    .news-body p { margin-bottom: 20px; }
    .news-body img { max-width: 100%; height: auto; border-radius: 8px; margin: 20px 0; }
    .news-tags { margin-bottom: 30px; padding-top: 20px; border-top: 1px solid #e5e7eb; }
    .news-tags span { font-weight: 600; margin-right: 10px; }
    .tag-link { display: inline-block; padding: 4px 12px; background: #f3f4f6; border-radius: 4px; text-decoration: none; color: #3b82f6; margin-right: 8px; font-size: 13px; }
    .news-author-box { display: flex; gap: 20px; padding: 25px; background: #f9fafb; border-radius: 12px; }
    .author-avatar { width: 80px; height: 80px; border-radius: 50%; overflow: hidden; flex-shrink: 0; }
    .author-avatar img { width: 100%; height: 100%; object-fit: cover; }
    .author-info h4 { font-size: 20px; font-weight: 700; margin-bottom: 8px; }
    .author-info p { color: #6b7280; margin-bottom: 10px; }
    .author-social { display: flex; gap: 10px; }
    .author-social a { width: 36px; height: 36px; display: flex; align-items: center; justify-content: center; background: #3b82f6; color: white; border-radius: 50%; text-decoration: none; }
    .related-news { margin-top: 50px; padding-top: 30px; border-top: 2px solid #e5e7eb; }
    .related-title { font-size: 28px; font-weight: 700; margin-bottom: 25px; }
    .related-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 20px; }
    .related-card { background: white; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
    .related-image { height: 150px; overflow: hidden; }
    .related-image img { width: 100%; height: 100%; object-fit: cover; }
    .related-content { padding: 15px; }
    .related-content h4 { font-size: 16px; font-weight: 600; margin-bottom: 8px; }
    .related-date { font-size: 12px; color: #9ca3af; }
    
    .news-sidebar { }
    .sidebar-ad { margin-bottom: 30px; text-align: center; }
    .sidebar-ad img { max-width: 100%; height: auto; border-radius: 8px; }
    .sidebar-widget { background: white; padding: 20px; border-radius: 12px; margin-bottom: 30px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
    .widget-title { font-size: 20px; font-weight: 700; margin-bottom: 15px; padding-bottom: 10px; border-bottom: 2px solid #3b82f6; }
    .widget-list { list-style: none; padding: 0; margin: 0; }
    .widget-list li { padding: 12px 0; border-bottom: 1px solid #f3f4f6; }
    .widget-list li:last-child { border-bottom: none; }
    .widget-list a { display: flex; align-items: center; gap: 10px; text-decoration: none; color: #1f2937; }
    .widget-number { font-size: 18px; font-weight: 700; color: #3b82f6; min-width: 30px; }
    .widget-text { flex: 1; font-size: 14px; }
    .widget-post-image { width: 80px; height: 60px; border-radius: 4px; overflow: hidden; flex-shrink: 0; }
    .widget-post-image img { width: 100%; height: 100%; object-fit: cover; }
    .widget-post-content { flex: 1; display: flex; flex-direction: column; gap: 5px; }
    .widget-post-title { font-size: 13px; font-weight: 600; }
    .widget-post-date { font-size: 11px; color: #9ca3af; }
    
    @media (max-width: 768px) {
        .news-layout { grid-template-columns: 1fr; }
        .news-title { font-size: 28px; }
        .related-grid { grid-template-columns: 1fr; }
    }
</style>
@endpush

@push('scripts')
<script>
    function copyToClipboard(text) {
        navigator.clipboard.writeText(text).then(function() {
            alert('Link copiado para a área de transferência!');
        });
    }
</script>
@endpush

