@if(isset($items))
<nav class="breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb-list">
        <li class="breadcrumb-item">
            <a href="{{ route('home.v1') }}">Home</a>
        </li>
        @foreach($items as $item)
        <li class="breadcrumb-item">
            @if(isset($item['url']))
                <a href="{{ $item['url'] }}">{{ $item['label'] }}</a>
            @else
                <span>{{ $item['label'] }}</span>
            @endif
        </li>
        @endforeach
    </ol>
</nav>

<style>
    .breadcrumb {
        margin-bottom: 20px;
    }
    
    .breadcrumb-list {
        display: flex;
        list-style: none;
        padding: 0;
        margin: 0;
        flex-wrap: wrap;
        gap: 5px;
        align-items: center;
    }
    
    .breadcrumb-item {
        font-size: 14px;
        color: #6b7280;
    }
    
    .breadcrumb-item:not(:last-child)::after {
        content: '/';
        margin: 0 8px;
        color: #9ca3af;
    }
    
    .breadcrumb-item a {
        color: #3b82f6;
        text-decoration: none;
    }
    
    .breadcrumb-item a:hover {
        text-decoration: underline;
    }
    
    .breadcrumb-item span {
        color: #1e293b;
        font-weight: 500;
    }
</style>
@endif

