<!-- Formulário de Busca -->
<div class="search-overlay" id="searchOverlay">
    <div class="search-modal">
        <form action="{{ route('news.search') }}" method="GET" class="search-form-modal">
            <input type="search" name="q" placeholder="Digite sua busca..." value="{{ request('q') }}" autofocus>
            <button type="submit"><i class="bi bi-search"></i> Buscar</button>
            <button type="button" class="close-search" onclick="document.getElementById('searchOverlay').style.display='none'">
                <i class="bi bi-x"></i>
            </button>
        </form>
    </div>
</div>

<style>
    .search-overlay {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0,0,0,0.8);
        z-index: 10000;
        align-items: center;
        justify-content: center;
    }
    
    .search-overlay.active {
        display: flex;
    }
    
    .search-modal {
        background: white;
        padding: 40px;
        border-radius: 12px;
        max-width: 600px;
        width: 90%;
        position: relative;
    }
    
    .search-form-modal input {
        width: 100%;
        padding: 15px;
        font-size: 18px;
        border: 2px solid #e5e7eb;
        border-radius: 8px;
        margin-bottom: 15px;
    }
    
    .search-form-modal button[type="submit"] {
        width: 100%;
        padding: 15px;
        background: #3b82f6;
        color: white;
        border: none;
        border-radius: 8px;
        font-size: 16px;
        font-weight: 600;
        cursor: pointer;
    }
    
    .close-search {
        position: absolute;
        top: 10px;
        right: 10px;
        background: none;
        border: none;
        font-size: 24px;
        color: #6b7280;
        cursor: pointer;
    }
</style>

