@extends('frontend.v2.layouts.app')

@section('title', $category->name . ' - Portal de Notícias')

@section('content')
<div class="category-page-v2">
    <div class="category-header-v2">
            <h1 class="category-title-v2" style="color: {{ $category->color ?? '#3b82f6' }};">
                {{ strtoupper($category->name) }}
            </h1>
            @if($category->description)
            <p class="category-description-v2">{{ $category->description }}</p>
            @endif
        </div>

    <div class="news-feed">
        @forelse($news as $item)
        <article class="news-item">
            <div class="news-item-content">
                <div class="news-item-image">
                    <a href="{{ route('news.show', $item->slug) }}">
                        <img src="{{ Storage::url($item->cover_image ?? 'default.jpg') }}" alt="{{ $item->title }}">
                    </a>
                </div>
                <div class="news-item-text">
                    <div class="news-item-meta">
                        <span class="news-date">{{ $item->published_at->format('d/m/Y') }}</span>
                        <span class="news-author">{{ $item->user->name }}</span>
                    </div>
                    <h2 class="news-item-title">
                        <a href="{{ route('news.show', $item->slug) }}">{{ $item->title }}</a>
                    </h2>
                    <p class="news-item-excerpt">{{ Str::limit($item->excerpt, 200) }}</p>
                    <div class="news-item-footer">
                        <a href="{{ route('news.show', $item->slug) }}" class="read-more">Ler mais →</a>
                        <span class="news-views"><i class="bi bi-eye"></i> {{ number_format($item->views) }}</span>
                    </div>
                </div>
            </div>
        </article>
        @empty
        <div class="no-news">
            <p>Nenhuma notícia encontrada nesta categoria.</p>
        </div>
        @endforelse
    </div>

    @if($news->hasPages())
    <div class="pagination-wrapper">
        {{ $news->links() }}
    </div>
    @endif
</div>
@endsection

@section('sidebar')
@include('frontend.v2.partials.sidebar', [
    'sidebarAds' => $sidebarAds ?? [],
    'mostRead' => $mostRead ?? collect(),
    'latestPosts' => $latestPosts ?? collect()
])
@endsection

