@extends('frontend.v2.layouts.app')

@section('title', 'Home - Portal de Notícias')

@section('content')
<!-- Grid de 6 Notícias em Destaque -->
<div class="featured-news-grid">
    @foreach($news->take(6) as $item)
    <article class="featured-news-card">
        <a href="{{ route('news.show', $item->slug) }}">
            <div class="featured-news-image">
                <img src="{{ Storage::url($item->cover_image ?? 'default.jpg') }}" alt="{{ $item->title }}">
            </div>
            <div class="featured-news-content">
                <h3>{{ Str::limit($item->title, 80) }}</h3>
            </div>
        </a>
    </article>
    @endforeach
</div>

<!-- Seção "MAIS NOTÍCIAS" -->
<div class="more-news-section">
    <h2 class="section-title-v2">MAIS NOTÍCIAS</h2>
    <div class="more-news-grid">
        @foreach($news->skip(6)->take(2) as $item)
        <article class="more-news-card">
            @if($item->is_featured)
            <span class="news-badge">Solidária</span>
            @endif
            <a href="{{ route('news.show', $item->slug) }}">
                <div class="more-news-image">
                    <img src="{{ Storage::url($item->cover_image ?? 'default.jpg') }}" alt="{{ $item->title }}">
                </div>
                <div class="more-news-content">
                    <h3>{{ $item->title }}</h3>
                </div>
            </a>
        </article>
        @endforeach
    </div>
</div>

<!-- Feed Linear de Notícias -->
<div class="news-feed">
    @forelse($news->skip(8) as $item)
    <article class="news-item">
        <div class="news-item-content">
            <div class="news-item-image">
                <a href="{{ route('news.show', $item->slug) }}">
                    <img src="{{ Storage::url($item->cover_image ?? 'default.jpg') }}" alt="{{ $item->title }}">
                </a>
            </div>
            <div class="news-item-text">
                <div class="news-item-meta">
                    <span class="news-category" style="color: {{ $item->category->color ?? '#3b82f6' }};">
                        {{ $item->category->name }}
                    </span>
                    <span class="news-date">{{ $item->published_at->format('d/m/Y') }}</span>
                    <span class="news-author">{{ $item->user->name }}</span>
                </div>
                <h2 class="news-item-title">
                    <a href="{{ route('news.show', $item->slug) }}">{{ $item->title }}</a>
                </h2>
                <div class="news-item-body">
                    {!! Str::limit(strip_tags($item->body ?? $item->excerpt), 300) !!}
                </div>
                @if($item->gallery && $item->gallery->images && $item->gallery->images->count() > 0)
                <div class="news-item-gallery">
                    @foreach($item->gallery->images->take(2) as $image)
                    <img src="{{ Storage::url($image->image) }}" alt="{{ $image->caption ?? 'Foto' }}">
                    @endforeach
                </div>
                @endif
                <div class="news-item-footer">
                    <a href="{{ route('news.show', $item->slug) }}" class="read-more">Ler mais →</a>
                    <span class="news-views"><i class="bi bi-eye"></i> {{ number_format($item->views) }}</span>
                </div>
            </div>
        </div>
    </article>
    @empty
    <div class="no-news">
        <p>Nenhuma notícia encontrada.</p>
    </div>
    @endforelse
</div>

<!-- Paginação -->
@if($news->hasPages())
<div class="pagination-wrapper">
    {{ $news->links() }}
</div>
@endif
@endsection

@section('sidebar')
@include('frontend.v2.partials.sidebar', [
    'sidebarAds' => $sidebarAds ?? [],
    'mostRead' => $mostRead ?? collect(),
    'latestPosts' => $latestPosts ?? collect()
])
@endsection


@push('styles')
<style>
    .featured-news-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 15px; margin-bottom: 30px; }
    .featured-news-card { background: white; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
    .featured-news-image { height: 150px; overflow: hidden; }
    .featured-news-image img { width: 100%; height: 100%; object-fit: cover; }
    .featured-news-content { padding: 12px; }
    .featured-news-content h3 { font-size: 14px; font-weight: 600; margin: 0; color: #1f2937; line-height: 1.4; }
    
    .more-news-section { margin: 40px 0; }
    .section-title-v2 { font-size: 24px; font-weight: 700; margin-bottom: 20px; color: #1f2937; text-transform: uppercase; }
    .more-news-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 20px; margin-bottom: 30px; }
    .more-news-card { position: relative; background: white; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
    .news-badge { position: absolute; top: 10px; left: 10px; background: #dc2626; color: white; padding: 4px 10px; border-radius: 4px; font-size: 11px; font-weight: 600; z-index: 1; }
    .more-news-image { height: 200px; overflow: hidden; }
    .more-news-image img { width: 100%; height: 100%; object-fit: cover; }
    .more-news-content { padding: 15px; }
    .more-news-content h3 { font-size: 16px; font-weight: 600; margin: 0; color: #1f2937; }
    
    .news-feed { padding: 20px 0; }
    .news-item { border-bottom: 1px solid #e5e7eb; padding: 30px 0; }
    .news-item:last-child { border-bottom: none; }
    .news-item-content { display: flex; gap: 20px; }
    .news-item-image { flex-shrink: 0; width: 300px; height: 200px; border-radius: 8px; overflow: hidden; }
    .news-item-image img { width: 100%; height: 100%; object-fit: cover; }
    .news-item-text { flex: 1; }
    .news-item-meta { display: flex; gap: 15px; margin-bottom: 10px; font-size: 13px; color: #6b7280; }
    .news-category { font-weight: 600; }
    .news-item-title { font-size: 24px; font-weight: 700; margin-bottom: 12px; }
    .news-item-title a { color: #1f2937; text-decoration: none; }
    .news-item-title a:hover { color: #3b82f6; }
    .news-item-body { font-size: 16px; line-height: 1.8; color: #4b5563; margin-bottom: 15px; }
    .news-item-gallery { display: flex; gap: 10px; margin: 15px 0; }
    .news-item-gallery img { width: 150px; height: 100px; object-fit: cover; border-radius: 4px; }
    .news-item-footer { display: flex; justify-content: space-between; align-items: center; }
    .read-more { color: #3b82f6; font-weight: 600; text-decoration: none; }
    .read-more:hover { text-decoration: underline; }
    .news-views { font-size: 13px; color: #9ca3af; }
    
    .sidebar-ad { margin-bottom: 30px; text-align: center; }
    .sidebar-widget { background: white; padding: 20px; border-radius: 8px; margin-bottom: 30px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); }
    .widget-title { font-size: 18px; font-weight: 700; margin-bottom: 15px; color: #1f2937; border-bottom: 2px solid #3b82f6; padding-bottom: 10px; }
    .widget-list { list-style: none; padding: 0; margin: 0; }
    .widget-list li { padding: 12px 0; border-bottom: 1px solid #f3f4f6; }
    .widget-list li:last-child { border-bottom: none; }
    .widget-list a { display: flex; align-items: center; gap: 10px; text-decoration: none; color: #1f2937; }
    .widget-number { font-size: 18px; font-weight: 700; color: #3b82f6; min-width: 30px; }
    .widget-text { flex: 1; font-size: 14px; }
    .widget-post-image { width: 80px; height: 60px; border-radius: 4px; overflow: hidden; flex-shrink: 0; }
    .widget-post-image img { width: 100%; height: 100%; object-fit: cover; }
    .widget-post-content { flex: 1; display: flex; flex-direction: column; gap: 5px; }
    .widget-post-title { font-size: 13px; font-weight: 600; color: #1f2937; }
    .widget-post-date { font-size: 11px; color: #9ca3af; }
    
    @media (max-width: 768px) {
        .featured-news-grid { grid-template-columns: repeat(2, 1fr); }
        .more-news-grid { grid-template-columns: 1fr; }
        .news-item-content { flex-direction: column; }
        .news-item-image { width: 100%; height: 250px; }
    }
</style>
@endpush
