@extends('frontend.v2.layouts.app')

@section('title', $news->meta_title ?: $news->title . ' - ' . config('app.name'))
@section('description', $news->meta_description ?: Str::limit(strip_tags($news->excerpt), 160))

@section('content')
<article class="news-article">
    <!-- Meta -->
    <div class="article-meta">
        <span class="article-category">{{ $news->category->name }}</span>
        <span class="article-date">{{ $news->published_at->format('d/m/Y H:i') }}</span>
    </div>

    <!-- Título -->
    <h1 class="article-title">{{ $news->title }}</h1>

    <!-- Foto Principal -->
    @if($news->cover_image)
    <figure class="article-image">
        <img src="{{ Storage::url($news->cover_image) }}" alt="{{ $news->title }}">
        @if($news->cover_credit)
        <figcaption>{{ $news->cover_credit }}</figcaption>
        @endif
    </figure>
    @endif

    <!-- Corpo -->
    <div class="article-body">
        {!! $news->body !!}
    </div>

    <!-- Compartilhamento -->
    <div class="article-share">
        <strong>Compartilhar:</strong>
        <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(url()->current()) }}" target="_blank" class="share-link">Facebook</a>
        <a href="https://twitter.com/intent/tweet?url={{ urlencode(url()->current()) }}" target="_blank" class="share-link">Twitter</a>
        <a href="https://api.whatsapp.com/send?text={{ urlencode($news->title . ' ' . url()->current()) }}" target="_blank" class="share-link">WhatsApp</a>
    </div>

    <!-- Tags -->
    @if($news->tags->count() > 0)
    <div class="article-tags">
        @foreach($news->tags as $tag)
        <a href="/tag/{{ $tag->slug }}" class="tag">{{ $tag->name }}</a>
        @endforeach
    </div>
    @endif
</article>
@endsection

