@extends('frontend.v2.layouts.app')

@section('title', $news->title)
@section('description', $news->excerpt)

@section('content')
<article class="news-page-v2">
    <!-- Breadcrumb -->
    <nav class="news-breadcrumb">
        <a href="{{ route('home') }}">Home</a>
        <span>/</span>
        <a href="{{ route('category.show', $news->category->slug) }}">{{ $news->category->name }}</a>
        <span>/</span>
        <span>{{ Str::limit($news->title, 40) }}</span>
    </nav>

    <!-- Título -->
    <h1 class="news-title-v2">{{ $news->title }}</h1>

    <!-- Meta -->
    <div class="news-meta-v2">
        <span class="news-date-v2">{{ $news->published_at->format('d/m/Y H:i') }}</span>
        <span class="news-author-v2">{{ $news->user->name }}</span>
        <span class="news-category-v2" style="color: {{ $news->category->color ?? '#3b82f6' }};">{{ $news->category->name }}</span>
    </div>

    <!-- Foto Principal -->
    @if($news->cover_image)
    <div class="news-cover-v2">
        <img src="{{ Storage::url($news->cover_image) }}" alt="{{ $news->title }}">
        @if($news->cover_credit)
        <p class="news-credit-v2">{{ $news->cover_credit }}</p>
        @endif
    </div>
    @endif

    <!-- Compartilhamento -->
    <div class="news-share-v2">
        <span>Compartilhar:</span>
        <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(url()->current()) }}" target="_blank" class="share-btn-v2 share-facebook">
            <i class="bi bi-facebook"></i>
        </a>
        <a href="https://twitter.com/intent/tweet?url={{ urlencode(url()->current()) }}&text={{ urlencode($news->title) }}" target="_blank" class="share-btn-v2 share-twitter">
            <i class="bi bi-twitter"></i>
        </a>
        <a href="https://api.whatsapp.com/send?text={{ urlencode($news->title . ' ' . url()->current()) }}" target="_blank" class="share-btn-v2 share-whatsapp">
            <i class="bi bi-whatsapp"></i>
        </a>
    </div>

    <!-- Corpo do Texto -->
    <div class="news-body-v2">
        {!! $news->body !!}
    </div>

    <!-- Tags -->
    @if($news->tags->count() > 0)
    <div class="news-tags-v2">
        <span>Tags:</span>
        @foreach($news->tags as $tag)
        <a href="#" class="tag-link-v2">{{ $tag->name }}</a>
        @endforeach
    </div>
    @endif

    <!-- Galeria (se houver) -->
    @if($news->gallery && $news->gallery->images->count() > 0)
    <div class="news-gallery-v2">
        <h3>Galeria de Fotos</h3>
        <div class="gallery-grid-v2">
            @foreach($news->gallery->images as $image)
            <div class="gallery-item-v2">
                <img src="{{ Storage::url($image->image) }}" alt="{{ $image->caption ?? 'Foto' }}">
                @if($image->caption)
                <p class="gallery-caption-v2">{{ $image->caption }}</p>
                @endif
            </div>
            @endforeach
        </div>
    </div>
    @endif
</article>
@endsection

@section('sidebar')
<!-- Anúncio 300x600 -->
@if(isset($sidebarAds['vertical_300x600']) && $sidebarAds['vertical_300x600'])
<div class="sidebar-ad">
    @if($sidebarAds['vertical_300x600']->format === 'image' && $sidebarAds['vertical_300x600']->image)
        <a href="{{ $sidebarAds['vertical_300x600']->link ?? '#' }}" target="_blank">
            <img src="{{ Storage::url($sidebarAds['vertical_300x600']->image) }}" alt="Anúncio" style="width: 300px; height: 600px; object-fit: cover;">
        </a>
    @elseif($sidebarAds['vertical_300x600']->format === 'html')
        {!! $sidebarAds['vertical_300x600']->content !!}
    @elseif($sidebarAds['vertical_300x600']->format === 'script')
        {!! $sidebarAds['vertical_300x600']->content !!}
    @endif
</div>
@endif

<!-- Mais Lidas -->
<div class="sidebar-widget">
    <h3 class="widget-title">Mais Lidas</h3>
    <ul class="widget-list">
        @foreach($mostRead as $read)
        <li>
            <a href="{{ route('news.show', $read->slug) }}">
                <span class="widget-number">{{ $loop->iteration }}</span>
                <span class="widget-text">{{ Str::limit($read->title, 60) }}</span>
            </a>
        </li>
        @endforeach
    </ul>
</div>

<!-- Anúncio 300x250 -->
@if(isset($sidebarAds['rectangle_300x250']) && $sidebarAds['rectangle_300x250'])
<div class="sidebar-ad">
    @if($sidebarAds['rectangle_300x250']->format === 'image' && $sidebarAds['rectangle_300x250']->image)
        <a href="{{ $sidebarAds['rectangle_300x250']->link ?? '#' }}" target="_blank">
            <img src="{{ Storage::url($sidebarAds['rectangle_300x250']->image) }}" alt="Anúncio" style="width: 300px; height: 250px; object-fit: cover;">
        </a>
    @elseif($sidebarAds['rectangle_300x250']->format === 'html')
        {!! $sidebarAds['rectangle_300x250']->content !!}
    @elseif($sidebarAds['rectangle_300x250']->format === 'script')
        {!! $sidebarAds['rectangle_300x250']->content !!}
    @endif
</div>
@endif

<!-- Últimos Posts -->
<div class="sidebar-widget">
    <h3 class="widget-title">Últimos Posts</h3>
    <ul class="widget-list">
        @foreach($latestPosts as $post)
        <li>
            <a href="{{ route('news.show', $post->slug) }}">
                <div class="widget-post-image">
                    <img src="{{ Storage::url($post->cover_image ?? 'default.jpg') }}" alt="{{ $post->title }}">
                </div>
                <div class="widget-post-content">
                    <span class="widget-post-title">{{ Str::limit($post->title, 50) }}</span>
                    <span class="widget-post-date">{{ $post->published_at->format('d/m/Y') }}</span>
                </div>
            </a>
        </li>
        @endforeach
    </ul>
</div>
@endsection

@push('styles')
<style>
    .news-page-v2 { padding: 30px 0; }
    .news-breadcrumb { margin-bottom: 15px; font-size: 13px; color: #6b7280; }
    .news-breadcrumb a { color: #3b82f6; text-decoration: none; }
    .news-title-v2 { font-size: 32px; font-weight: 700; line-height: 1.3; margin-bottom: 15px; color: #1f2937; }
    .news-meta-v2 { display: flex; gap: 15px; margin-bottom: 20px; font-size: 14px; color: #6b7280; }
    .news-category-v2 { font-weight: 600; }
    .news-cover-v2 { margin-bottom: 25px; }
    .news-cover-v2 img { width: 100%; border-radius: 8px; }
    .news-credit-v2 { font-size: 12px; color: #9ca3af; margin-top: 8px; text-align: center; }
    .news-share-v2 { display: flex; align-items: center; gap: 10px; margin-bottom: 25px; padding: 12px; background: #f9fafb; border-radius: 6px; }
    .share-btn-v2 { width: 36px; height: 36px; display: flex; align-items: center; justify-content: center; border-radius: 50%; text-decoration: none; color: white; }
    .share-facebook { background: #1877f2; }
    .share-twitter { background: #1da1f2; }
    .share-whatsapp { background: #25d366; }
    .news-body-v2 { font-size: 18px; line-height: 1.8; color: #374151; margin-bottom: 30px; }
    .news-body-v2 p { margin-bottom: 20px; }
    .news-body-v2 img { max-width: 100%; height: auto; border-radius: 6px; margin: 20px 0; }
    .news-tags-v2 { margin-top: 30px; padding-top: 20px; border-top: 1px solid #e5e7eb; }
    .news-tags-v2 span { font-weight: 600; margin-right: 10px; }
    .tag-link-v2 { display: inline-block; padding: 4px 12px; background: #f3f4f6; border-radius: 4px; text-decoration: none; color: #3b82f6; margin-right: 8px; font-size: 13px; }
    .news-gallery-v2 { margin-top: 40px; padding-top: 30px; border-top: 2px solid #e5e7eb; }
    .news-gallery-v2 h3 { font-size: 24px; font-weight: 700; margin-bottom: 20px; }
    .gallery-grid-v2 { display: grid; grid-template-columns: repeat(3, 1fr); gap: 15px; }
    .gallery-item-v2 { border-radius: 8px; overflow: hidden; }
    .gallery-item-v2 img { width: 100%; height: 200px; object-fit: cover; }
    .gallery-caption-v2 { font-size: 12px; color: #6b7280; margin-top: 5px; text-align: center; }
</style>
@endpush

