<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Instalação do Portal Bahia</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .installer-card {
            background: white;
            border-radius: 12px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            max-width: 900px;
            margin: 0 auto;
            padding: 40px;
        }
        .step-indicator {
            display: flex;
            justify-content: space-between;
            margin-bottom: 40px;
            border-bottom: 2px solid #e5e7eb;
            padding-bottom: 20px;
        }
        .step {
            flex: 1;
            text-align: center;
            padding: 10px;
            color: #9ca3af;
            font-weight: 500;
            cursor: pointer;
        }
        .step.active {
            color: #3b82f6;
            border-bottom: 3px solid #3b82f6;
        }
        .alert {
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .form-label {
            font-weight: 600;
            color: #374151;
            margin-bottom: 8px;
        }
        .form-control {
            border-radius: 8px;
            padding: 12px;
        }
        .btn-primary {
            background: #3b82f6;
            border: none;
            border-radius: 8px;
            padding: 12px 24px;
            font-weight: 600;
        }
        .btn-primary:hover {
            background: #2563eb;
        }
        .help-text {
            font-size: 0.875rem;
            color: #6b7280;
            margin-top: 5px;
        }
    </style>
</head>
<body>
    <div class="installer-card">
        <h1 class="text-center mb-2">Instalação do Portal Bahia</h1>
        <p class="text-center text-muted mb-4">Versão 1.0.0 - Desenvolvido por Robson Rost / Grupo Website VIX</p>

        <div class="step-indicator">
            <div class="step" id="step-1">1. Requisitos</div>
            <div class="step" id="step-2">2. Banco</div>
            <div class="step active" id="step-3">3. Licença</div>
            <div class="step" id="step-4">4. Admin</div>
            <div class="step" id="step-5">5. Concluído</div>
        </div>

        <div id="alert-container"></div>

        <!-- Step 3: Licença -->
        <div id="step-3-content">
            <h3 class="mb-4">Validação de Licença</h3>
            <p class="text-muted mb-4">Você precisa de uma License Key válida do Master Panel para instalar o portal.</p>

            <form id="license-form">
                <div class="mb-3">
                    <label for="master_panel_url" class="form-label">URL do Master Panel *</label>
                    <input type="url" class="form-control" id="master_panel_url" name="master_panel_url" 
                           value="https://master.canal33.com.br" required>
                    <div class="help-text">URL completa do Master Panel (ex: https://master.canal33.com.br)</div>
                </div>

                <div class="mb-3">
                    <label for="license_key" class="form-label">License Key *</label>
                    <input type="text" class="form-control" id="license_key" name="license_key" 
                           placeholder="PVX-XXXXXXXX-XXXXXXXX-XXXXXXXX" required>
                    <div class="help-text">Obtenha sua License Key no painel master</div>
                </div>

                <div class="d-grid">
                    <button type="submit" class="btn btn-primary">
                        Validar Licença e Continuar →
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            // CSRF Token
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            // Formulário de licença
            $('#license-form').on('submit', function(e) {
                e.preventDefault();

                const $form = $(this);
                const $btn = $form.find('button[type="submit"]');
                const originalText = $btn.html();
                
                $btn.prop('disabled', true).html('<i class="bi bi-hourglass-split"></i> Validando...');

                // Limpar alertas anteriores
                $('#alert-container').empty();

                $.ajax({
                    url: '{{ route("installer.validate-license") }}',
                    method: 'POST',
                    data: {
                        master_panel_url: $('#master_panel_url').val(),
                        license_key: $('#license_key').val()
                    },
                    success: function(response) {
                        if (response.success) {
                            $('#alert-container').html(
                                '<div class="alert alert-success">' +
                                '<i class="bi bi-check-circle"></i> ' + response.message +
                                '</div>'
                            );
                            
                            // Redirecionar para próximo passo após 1 segundo
                            setTimeout(function() {
                                window.location.href = '{{ route("installer.admin") }}';
                            }, 1000);
                        } else {
                            $('#alert-container').html(
                                '<div class="alert alert-danger">' +
                                '<i class="bi bi-exclamation-triangle"></i> ' + response.message +
                                '</div>'
                            );
                            $btn.prop('disabled', false).html(originalText);
                        }
                    },
                    error: function(xhr) {
                        let message = 'Erro ao validar licença.';
                        
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            message = xhr.responseJSON.message;
                        } else if (xhr.status === 0) {
                            message = 'Erro de conexão. Verifique sua internet e se a URL do Master Panel está correta.';
                        }

                        $('#alert-container').html(
                            '<div class="alert alert-danger">' +
                            '<i class="bi bi-exclamation-triangle"></i> ' + message +
                            '</div>'
                        );
                        $btn.prop('disabled', false).html(originalText);
                    }
                });
            });

            // Validar e corrigir URL em tempo real
            $('#master_panel_url').on('blur', function() {
                let url = $(this).val().trim();
                
                // Adicionar https:// se não tiver
                if (url && !url.match(/^https?:\/\//)) {
                    url = 'https://' + url;
                }
                
                // Corrigir URLs do canal33 que estejam truncadas
                if (url.includes('canal33.com')) {
                    // Corrigir .com.b ou .com para .com.br
                    url = url.replace(/\.com\.?b?r?(\/|$)/, '.com.br$1');
                }
                
                // Remover barra final
                url = url.replace(/\/$/, '');
                
                $(this).val(url);
            });
            
            // Também corrigir ao digitar
            $('#master_panel_url').on('input', function() {
                let url = $(this).val();
                if (url.includes('canal33.com') && url.match(/\.com\.?b?$/)) {
                    // Se terminar com .com ou .com.b, adicionar .br
                    setTimeout(() => {
                        let corrected = url.replace(/\.com\.?b?$/, '.com.br');
                        if (corrected !== url) {
                            $(this).val(corrected);
                        }
                    }, 100);
                }
            });
        });
    </script>
</body>
</html>

