<?php

use Illuminate\Support\Facades\Route;

// Rotas Públicas - Frontend

// Verificar se o sistema está instalado antes de mostrar o frontend
Route::get('/', function() {
    // Se o sistema não estiver instalado, redirecionar para o instalador
    if (!file_exists(storage_path('installed'))) {
        return redirect('/install');
    }
    
    // Se estiver instalado, mostrar a home conforme template configurado
    try {
        $template = setting('active_template', 'v1');
        if ($template === 'v2') {
            return app(\App\Http\Controllers\HomeController::class)->indexV2();
        }
        return app(\App\Http\Controllers\HomeController::class)->indexV1();
    } catch (\Exception $e) {
        // Se houver erro (ex: banco não configurado), redirecionar para instalação
        return redirect('/install');
    }
})->name('home');

// Rotas específicas para cada template (para preview)
Route::get('/v1', function() {
    if (!file_exists(storage_path('installed'))) {
        return redirect('/install');
    }
    try {
        return app(\App\Http\Controllers\HomeController::class)->indexV1();
    } catch (\Exception $e) {
        return redirect('/install');
    }
})->name('home.v1');

Route::get('/v2', function() {
    if (!file_exists(storage_path('installed'))) {
        return redirect('/install');
    }
    try {
        return app(\App\Http\Controllers\HomeController::class)->indexV2();
    } catch (\Exception $e) {
        return redirect('/install');
    }
})->name('home.v2');

// Middleware para verificar instalação nas rotas do frontend
Route::middleware(function ($request, $next) {
    if (!file_exists(storage_path('installed'))) {
        return redirect('/install');
    }
    return $next($request);
})->group(function () {
    
    // Rotas de Notícias - Usa template selecionado
    Route::get('/noticia/{slug}', function($slug) {
        try {
            $template = setting('active_template', 'v1');
            if ($template === 'v2') {
                return app(\App\Http\Controllers\NewsController::class)->showV2($slug);
            }
            return app(\App\Http\Controllers\NewsController::class)->showV1($slug);
        } catch (\Exception $e) {
            return redirect('/install');
        }
    })->name('news.show');

    Route::get('/categoria/{slug}', function($slug) {
        try {
            $template = setting('active_template', 'v1');
            if ($template === 'v2') {
                return app(\App\Http\Controllers\NewsController::class)->categoryV2($slug);
            }
            return app(\App\Http\Controllers\NewsController::class)->categoryV1($slug);
        } catch (\Exception $e) {
            return redirect('/install');
        }
    })->name('category.show');
});

// Rotas específicas para cada template (para preview)
Route::get('/v1/noticia/{slug}', function($slug) {
    if (!file_exists(storage_path('installed'))) {
        return redirect('/install');
    }
    try {
        return app(\App\Http\Controllers\NewsController::class)->showV1($slug);
    } catch (\Exception $e) {
        return redirect('/install');
    }
})->name('news.show.v1');

Route::get('/v1/categoria/{slug}', function($slug) {
    if (!file_exists(storage_path('installed'))) {
        return redirect('/install');
    }
    try {
        return app(\App\Http\Controllers\NewsController::class)->categoryV1($slug);
    } catch (\Exception $e) {
        return redirect('/install');
    }
})->name('category.show.v1');

Route::get('/v2/noticia/{slug}', function($slug) {
    if (!file_exists(storage_path('installed'))) {
        return redirect('/install');
    }
    try {
        return app(\App\Http\Controllers\NewsController::class)->showV2($slug);
    } catch (\Exception $e) {
        return redirect('/install');
    }
})->name('news.show.v2');

Route::get('/v2/categoria/{slug}', function($slug) {
    if (!file_exists(storage_path('installed'))) {
        return redirect('/install');
    }
    try {
        return app(\App\Http\Controllers\NewsController::class)->categoryV2($slug);
    } catch (\Exception $e) {
        return redirect('/install');
    }
})->name('category.show.v2');

// Busca
Route::get('/buscar', function() {
    if (!file_exists(storage_path('installed'))) {
        return redirect('/install');
    }
    try {
        return app(\App\Http\Controllers\NewsController::class)->search(request());
    } catch (\Exception $e) {
        return redirect('/install');
    }
})->name('news.search');

// API Routes
Route::prefix('api')->group(function() {
    Route::get('/search/autocomplete', [\App\Http\Controllers\Api\SearchController::class, 'autocomplete'])->name('api.search.autocomplete');
});
