<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\InstallerController;

/*
|--------------------------------------------------------------------------
| Installer Routes
|--------------------------------------------------------------------------
|
| Rotas do instalador do Portal
|
*/

Route::prefix('install')->name('installer.')->group(function () {
    Route::get('/', [InstallerController::class, 'index'])->name('index');
    Route::post('/check-requirements', [InstallerController::class, 'checkRequirements'])->name('check-requirements');
    Route::post('/validate-database', [InstallerController::class, 'validateDatabase'])->name('validate-database');
    Route::post('/validate-license', [InstallerController::class, 'validateLicense'])->name('validate-license');
    Route::post('/create-admin', [InstallerController::class, 'createAdmin'])->name('create-admin');
    Route::post('/finish', [InstallerController::class, 'finish'])->name('finish');
});

