<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\NewsController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\VideoController;
use App\Http\Controllers\Admin\GalleryController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

// Instalador
Route::get('/install', function () {
    if (file_exists(storage_path('installed'))) {
        return redirect()->route('admin.dashboard');
    }
    return redirect('/install/index.php');
});

// Autenticação
Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [LoginController::class, 'login']);
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

// Rotas administrativas (protegidas)
Route::middleware(['auth', 'license.check'])->prefix('admin')->name('admin.')->group(function () {
    
    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/', [DashboardController::class, 'index']);

    // Notícias
    Route::resource('news', NewsController::class);
    Route::post('news/{news}/duplicate', [NewsController::class, 'duplicate'])->name('news.duplicate');
    Route::post('news/{news}/status', [NewsController::class, 'changeStatus'])->name('news.change-status');
    Route::post('news/bulk-action', [NewsController::class, 'bulkAction'])->name('news.bulk-action');
    Route::post('news/{news}/trash', [NewsController::class, 'trash'])->name('news.trash');
    Route::post('news/{id}/restore', [NewsController::class, 'restore'])->name('news.restore');

    // Categorias
    Route::resource('categories', CategoryController::class);
    Route::post('categories/reorder', [CategoryController::class, 'reorder'])->name('categories.reorder');

    // Vídeos
    Route::resource('videos', VideoController::class);
    Route::post('videos/{id}/restore', [VideoController::class, 'restore'])->name('videos.restore');

    // Galerias
    Route::resource('galleries', GalleryController::class);
    Route::delete('galleries/images/{image}', [GalleryController::class, 'deleteImage'])->name('galleries.images.destroy');
    Route::post('galleries/{id}/restore', [GalleryController::class, 'restore'])->name('galleries.restore');

    // Enquetes
    Route::resource('polls', \App\Http\Controllers\Admin\PollController::class);
    Route::get('polls/{poll}/results', [\App\Http\Controllers\Admin\PollController::class, 'results'])->name('polls.results');
    Route::get('polls/{poll}/export-csv', [\App\Http\Controllers\Admin\PollController::class, 'exportCsv'])->name('polls.export-csv');

    // Anúncios
    Route::resource('ads', \App\Http\Controllers\Admin\AdController::class);
    Route::get('ads/positions', [\App\Http\Controllers\Admin\AdController::class, 'positions'])->name('ads.positions');
    Route::post('ads/positions', [\App\Http\Controllers\Admin\AdController::class, 'storePosition'])->name('ads.positions.store');
    Route::get('ads/positions/{position}', [\App\Http\Controllers\Admin\AdController::class, 'showPosition'])->name('ads.positions.show');
    Route::put('ads/positions/{position}', [\App\Http\Controllers\Admin\AdController::class, 'updatePosition'])->name('ads.positions.update');
    Route::delete('ads/positions/{position}', [\App\Http\Controllers\Admin\AdController::class, 'destroyPosition'])->name('ads.positions.destroy');
    Route::post('ads/positions/create-default', [\App\Http\Controllers\Admin\AdController::class, 'createDefaultPositions'])->name('ads.positions.create-default');

    // Classificados
    Route::resource('classifieds', \App\Http\Controllers\Admin\ClassifiedController::class);
    Route::post('classifieds/{classified}/approve', [\App\Http\Controllers\Admin\ClassifiedController::class, 'approve'])->name('classifieds.approve');
    Route::post('classifieds/{id}/restore', [\App\Http\Controllers\Admin\ClassifiedController::class, 'restore'])->name('classifieds.restore');

    // Usuários
    Route::resource('users', \App\Http\Controllers\Admin\UserController::class);

    // AutoPost
    Route::resource('autopost', \App\Http\Controllers\Admin\AutoPostController::class);
    Route::post('autopost/{job}/run', [\App\Http\Controllers\Admin\AutoPostController::class, 'run'])->name('autopost.run');
    Route::get('autopost/{job}/logs', [\App\Http\Controllers\Admin\AutoPostController::class, 'logs'])->name('autopost.logs');

    // Plugins
    Route::get('plugins', [\App\Http\Controllers\Admin\PluginController::class, 'index'])->name('plugins.index');
    Route::post('plugins/{pluginSlug}/install', [\App\Http\Controllers\Admin\PluginController::class, 'install'])->name('plugins.install');
    Route::post('plugins/upload', [\App\Http\Controllers\Admin\PluginController::class, 'upload'])->name('plugins.upload');
    Route::delete('plugins/{plugin}/uninstall', [\App\Http\Controllers\Admin\PluginController::class, 'uninstall'])->name('plugins.uninstall');
    Route::post('plugins/{plugin}/toggle', [\App\Http\Controllers\Admin\PluginController::class, 'toggle'])->name('plugins.toggle');
    Route::get('plugins/{plugin}/configure', [\App\Http\Controllers\Admin\PluginController::class, 'configure'])->name('plugins.configure');
    Route::post('plugins/{plugin}/configure', [\App\Http\Controllers\Admin\PluginController::class, 'updateConfig'])->name('plugins.update-config');

    // Municípios
    Route::resource('municipalities', \App\Http\Controllers\Admin\MunicipalityController::class);
    Route::get('municipalities/import', [\App\Http\Controllers\Admin\MunicipalityController::class, 'import'])->name('municipalities.import');

    // Páginas CMS
    Route::resource('pages', \App\Http\Controllers\Admin\PageController::class);

    // Configurações
    Route::get('settings', [\App\Http\Controllers\Admin\SettingsController::class, 'index'])->name('settings.index');
    Route::post('settings', [\App\Http\Controllers\Admin\SettingsController::class, 'update'])->name('settings.update');
    Route::get('settings/general', [\App\Http\Controllers\Admin\SettingsController::class, 'general'])->name('settings.general');
    Route::get('settings/seo', [\App\Http\Controllers\Admin\SettingsController::class, 'seo'])->name('settings.seo');
    Route::get('settings/scripts', [\App\Http\Controllers\Admin\SettingsController::class, 'scripts'])->name('settings.scripts');
    Route::get('settings/templates', [\App\Http\Controllers\Admin\SettingsController::class, 'templates'])->name('settings.templates');
    Route::put('settings/templates', [\App\Http\Controllers\Admin\SettingsController::class, 'updateTemplates'])->name('settings.templates.update');

    // Lixeira
    Route::get('trash', [\App\Http\Controllers\Admin\TrashController::class, 'index'])->name('trash.index');
    Route::post('trash/{type}/{id}/restore', [\App\Http\Controllers\Admin\TrashController::class, 'restore'])->name('trash.restore');
    Route::delete('trash/{type}/{id}', [\App\Http\Controllers\Admin\TrashController::class, 'destroy'])->name('trash.destroy');
    Route::post('trash/empty', [\App\Http\Controllers\Admin\TrashController::class, 'empty'])->name('trash.empty');

    // Relatórios
    Route::get('reports', [\App\Http\Controllers\Admin\ReportController::class, 'index'])->name('reports.index');

    // Anúncios (a implementar)
    // Route::resource('ads', AdController::class);

    // Classificados (a implementar)
    // Route::resource('classifieds', ClassifiedController::class);

    // Usuários (a implementar)
    // Route::resource('users', UserController::class);

    // Plugins (a implementar)
    // Route::resource('plugins', PluginController::class);

    // Configurações (a implementar)
    // Route::get('settings', [SettingsController::class, 'index'])->name('settings.index');
    // Route::post('settings', [SettingsController::class, 'update'])->name('settings.update');
});

// Rotas públicas (frontend)
require __DIR__.'/frontend.php';

